/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Properties;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PrivateKey;
import net.i2p.data.PrivateKeyFile;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.VersionComparator;

public class CreateRouterInfoJob
extends JobImpl {
    private final Log _log;
    private final Job _next;
    public static final String INFO_FILENAME = "router.info";
    public static final String KEYS_FILENAME = "router.keys";
    public static final String KEYS2_FILENAME = "router.keys.dat";
    static final String PROP_ROUTER_SIGTYPE = "router.sigType";
    static final String PROP_ROUTER_ENCTYPE = "router.encType";
    private static final SigType DEFAULT_SIGTYPE = SigType.EdDSA_SHA512_Ed25519;
    private static final EncType DEFAULT_ENCTYPE = VersionComparator.comp("0.9.50", "0.9.49") >= 0 ? EncType.ECIES_X25519 : EncType.ELGAMAL_2048;

    CreateRouterInfoJob(RouterContext ctx, Job next) {
        super(ctx);
        this._next = next;
        this._log = ctx.logManager().getLog(CreateRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Create New Router Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        this._log.debug("Creating the new router info");
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            this.createRouterInfo();
        }
        this.getContext().jobQueue().addJob(this._next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RouterInfo createRouterInfo() {
        RouterContext ctx = this.getContext();
        SigType type = CreateRouterInfoJob.getSigTypeConfig(ctx);
        RouterInfo info = new RouterInfo();
        OutputStream fos1 = null;
        try {
            byte[] padding;
            info.setAddresses(ctx.commSystem().createAddresses());
            info.setPublished(CreateRouterInfoJob.getCurrentPublishDate(ctx));
            EncType etype = CreateRouterInfoJob.getEncTypeConfig(ctx);
            KeyPair keypair = ctx.keyGenerator().generatePKIKeys(etype);
            PublicKey pubkey = keypair.getPublic();
            PrivateKey privkey = keypair.getPrivate();
            SimpleDataStructure[] signingKeypair = ctx.keyGenerator().generateSigningKeys(type);
            SigningPublicKey signingPubKey = (SigningPublicKey)signingKeypair[0];
            SigningPrivateKey signingPrivKey = (SigningPrivateKey)signingKeypair[1];
            RouterIdentity ident = new RouterIdentity();
            Certificate cert = CreateRouterInfoJob.createCertificate(ctx, signingPubKey, pubkey);
            ident.setCertificate(cert);
            ident.setPublicKey(pubkey);
            ident.setSigningPublicKey(signingPubKey);
            int padLen = SigningPublicKey.KEYSIZE_BYTES - signingPubKey.length() + (PublicKey.KEYSIZE_BYTES - pubkey.length());
            if (padLen > 0) {
                padding = new byte[padLen];
                ctx.random().nextBytes(padding);
                ident.setPadding(padding);
            } else {
                padding = null;
            }
            info.setIdentity(ident);
            Properties stats = ctx.statPublisher().publishStatistics(ident.getHash());
            info.setOptions(stats);
            info.sign(signingPrivKey);
            if (!info.isValid()) {
                throw new DataFormatException("RouterInfo we just built is invalid: " + info);
            }
            new File(ctx.getRouterDir(), KEYS_FILENAME).delete();
            File ifile = new File(ctx.getRouterDir(), INFO_FILENAME);
            fos1 = new BufferedOutputStream(new SecureFileOutputStream(ifile));
            info.writeBytes(fos1);
            File kfile = new File(ctx.getRouterDir(), KEYS2_FILENAME);
            PrivateKeyFile pkf = new PrivateKeyFile(kfile, pubkey, signingPubKey, cert, privkey, signingPrivKey, padding);
            pkf.write();
            HashMap<String, String> map = new HashMap<String, String>(2);
            byte[] rk = new byte[32];
            ctx.random().nextBytes(rk);
            map.put("router.inboundPool.randomKey", Base64.encode(rk));
            ctx.random().nextBytes(rk);
            map.put("router.outboundPool.randomKey", Base64.encode(rk));
            ctx.router().saveConfig(map, null);
            ctx.keyManager().setKeys(pubkey, privkey, signingPubKey, signingPrivKey);
            if (this._log.shouldLog(20)) {
                this._log.info("Router info created and stored at " + ifile.getAbsolutePath() + " with private keys stored at " + kfile.getAbsolutePath() + " [" + info + "]");
            }
            ctx.router().eventLog().addEvent("rekeyed", ident.calculateHash().toBase64());
        }
        catch (GeneralSecurityException gse) {
            this._log.log(50, "Error building the new router information", gse);
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Error building the new router information", dfe);
        }
        catch (IOException ioe) {
            this._log.log(50, "Error writing out the new router information", ioe);
        }
        finally {
            if (fos1 != null) {
                try {
                    fos1.close();
                }
                catch (IOException gse) {}
            }
        }
        return info;
    }

    public static SigType getSigTypeConfig(RouterContext ctx) {
        SigType ntype;
        SigType cstype = DEFAULT_SIGTYPE;
        String sstype = ctx.getProperty(PROP_ROUTER_SIGTYPE);
        if (sstype != null && (ntype = SigType.parseSigType(sstype)) != null) {
            cstype = ntype;
        }
        if (cstype != SigType.DSA_SHA1 && !cstype.isAvailable()) {
            cstype = SigType.DSA_SHA1;
        }
        return cstype;
    }

    public static EncType getEncTypeConfig(RouterContext ctx) {
        EncType ntype;
        EncType cstype = DEFAULT_ENCTYPE;
        String sstype = ctx.getProperty(PROP_ROUTER_ENCTYPE);
        if (sstype != null && (ntype = EncType.parseEncType(sstype)) != null) {
            cstype = ntype;
        }
        if (cstype != EncType.ELGAMAL_2048 && !cstype.isAvailable()) {
            cstype = EncType.ELGAMAL_2048;
        }
        return cstype;
    }

    static long getCurrentPublishDate(RouterContext context) {
        return context.clock().now();
    }

    private static Certificate createCertificate(RouterContext ctx, SigningPublicKey spk, PublicKey pk) {
        if (spk.getType() != SigType.DSA_SHA1 || pk.getType() != EncType.ELGAMAL_2048) {
            return new KeyCertificate(spk, pk);
        }
        if (ctx.getBooleanProperty("router.hiddenMode")) {
            return new Certificate(2, null);
        }
        return Certificate.NULL_CERT;
    }
}

