/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;

public class FileUIUtils {
    private FileUIUtils() {
    }

    @Nullable
    public static File copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull String destinationFolder, @NotNull File file) {
        Map<File, File> copiedFiles;
        if (messagesTitle == null) {
            FileUIUtils.$$$reportNull$$$0(0);
        }
        if (destinationFolder == null) {
            FileUIUtils.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FileUIUtils.$$$reportNull$$$0(2);
        }
        if ((copiedFiles = FileUIUtils.copyWithOverwriteDialog(messagesTitle, (Map<File, String>)ImmutableMap.of((Object)file, (Object)destinationFolder))) == null) {
            return null;
        }
        File copy = copiedFiles.get(file);
        assert (copy != null);
        return copy;
    }

    @Nullable
    public static Map<File, File> copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull Map<File, String> filesWithDestinations) {
        String destinationPath;
        if (messagesTitle == null) {
            FileUIUtils.$$$reportNull$$$0(3);
        }
        if (filesWithDestinations == null) {
            FileUIUtils.$$$reportNull$$$0(4);
        }
        HashSet<String> fileNames = new HashSet<String>();
        LinkedHashMap<File, File> targetFiles = new LinkedHashMap<File, File>(filesWithDestinations.size());
        for (Map.Entry<File, String> sourceToDestination : filesWithDestinations.entrySet()) {
            File file = sourceToDestination.getKey();
            destinationPath = sourceToDestination.getValue();
            String fileName = file.getName();
            if (!fileNames.add(fileName)) {
                throw new IllegalArgumentException("There are several files with the same name: " + fileName);
            }
            targetFiles.put(file, new File(destinationPath, fileName));
        }
        List existentFiles = CollectionsKt.filter(targetFiles.entrySet(), sourceToTarget -> ((File)sourceToTarget.getValue()).exists());
        if (!existentFiles.isEmpty()) {
            String message;
            if (existentFiles.size() == 1) {
                File conflictingFile = (File)((Map.Entry)existentFiles.iterator().next()).getValue();
                message = KotlinJvmBundle.message("file.exists.single", conflictingFile.getName(), conflictingFile.getParentFile().getAbsolutePath());
            } else {
                List conflictFiles = CollectionsKt.map((Iterable)existentFiles, Map.Entry::getValue);
                message = KotlinJvmBundle.message("file.exists", StringUtil.join((Iterable)conflictFiles, (String)"\n"));
            }
            int replaceIfExist = Messages.showYesNoDialog(null, (String)message, (String)(messagesTitle + KotlinJvmBundle.message("file.overwrite.title", new Object[0])), (String)KotlinJvmBundle.message("file.overwrite.overwrite", new Object[0]), (String)KotlinJvmBundle.message("file.overwrite.cancel", new Object[0]), (Icon)Messages.getWarningIcon());
            if (replaceIfExist != 0) {
                return null;
            }
        }
        for (Map.Entry sourceToTarget2 : targetFiles.entrySet()) {
            try {
                destinationPath = ((File)sourceToTarget2.getValue()).getParentFile().getAbsolutePath();
                if (!ProjectWizardUtil.createDirectoryIfNotExists((String)KotlinJvmBundle.message("file.destination.folder", new Object[0]), (String)destinationPath, (boolean)false)) {
                    Messages.showErrorDialog((String)KotlinJvmBundle.message("file.error.new.folder", destinationPath), (String)messagesTitle);
                    return null;
                }
                FileUtil.copy((File)((File)sourceToTarget2.getKey()), (File)((File)sourceToTarget2.getValue()));
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)sourceToTarget2.getValue());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)KotlinJvmBundle.message("file.error.copy", ((File)sourceToTarget2.getKey()).getName()), (String)messagesTitle);
                return null;
            }
        }
        return targetFiles;
    }

    @NotNull
    public static String createRelativePath(@Nullable Project project, @Nullable VirtualFile contextDirectory, String relativePath) {
        String path = null;
        if (contextDirectory != null) {
            path = PathUtil.getLocalPath((VirtualFile)contextDirectory);
        } else if (project != null) {
            path = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
        }
        path = path != null ? new File(path, relativePath).getAbsolutePath() : "";
        String string = path;
        if (string == null) {
            FileUIUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagesTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWithDestinations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyWithOverwriteDialog";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

