/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AbstractChangeFeatureSupportLevelFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix$InProject$WhenMappings;
import org.jetbrains.kotlin.idea.quickfix.EnableUnsupportedFeatureFixKt;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix;", "element", "Lcom/intellij/psi/PsiElement;", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "Companion", "InModule", "InProject", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InProject;", "kotlin.jvm"})
public abstract class ChangeCoroutineSupportFix
extends AbstractChangeFeatureSupportLevelFix {
    public static final Companion Companion = new Companion(null);

    private ChangeCoroutineSupportFix(PsiElement element, LanguageFeature.State coroutineSupport) {
        super(element, LanguageFeature.Coroutines, coroutineSupport, ChangeCoroutineSupportFix.Companion.getShortFeatureName());
    }

    public /* synthetic */ ChangeCoroutineSupportFix(PsiElement element, LanguageFeature.State coroutineSupport, DefaultConstructorMarker $constructor_marker) {
        this(element, coroutineSupport);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "element", "Lcom/intellij/psi/PsiElement;", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm"})
    public static final class InModule
    extends ChangeCoroutineSupportFix {
        @NotNull
        public String getText() {
            return KotlinJvmBundle.message("fix.0.in.current.module", super.getText());
        }

        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
            if (module == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026siElement(file) ?: return");
            Module module2 = module;
            ConfigureKotlinInProjectUtilsKt.findApplicableConfigurator(module2).changeCoroutineConfiguration(module2, this.getFeatureSupport());
        }

        public InModule(@NotNull PsiElement element, @NotNull LanguageFeature.State coroutineSupport) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)coroutineSupport, (String)"coroutineSupport");
            super(element, coroutineSupport, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InProject;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "element", "Lcom/intellij/psi/PsiElement;", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm"})
    public static final class InProject
    extends ChangeCoroutineSupportFix {
        @NotNull
        public String getText() {
            return KotlinJvmBundle.message("fix.0.in.the.project", super.getText());
        }

        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (this.getFeatureSupportEnabled() && !EnableUnsupportedFeatureFixKt.checkUpdateRuntime(project, LanguageFeature.Coroutines.getSinceApiVersion())) {
                return;
            }
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project).update((Function1)new Function1<CommonCompilerArguments, Unit>(this){
                final /* synthetic */ InProject this$0;

                public final void invoke(@NotNull CommonCompilerArguments $this$update) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$receiver");
                    switch (ChangeCoroutineSupportFix$InProject$WhenMappings.$EnumSwitchMapping$0[this.this$0.getFeatureSupport().ordinal()]) {
                        case 1: {
                            string = "enable";
                            break;
                        }
                        case 2: {
                            string = "warn";
                            break;
                        }
                        case 3: 
                        case 4: {
                            string = "error";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    $this$update.setCoroutinesState(string);
                }
                {
                    this.this$0 = inProject;
                    super(1);
                }
            });
            RootUtilsKt.invalidateProjectRoots((Project)project);
        }

        public InProject(@NotNull PsiElement element, @NotNull LanguageFeature.State coroutineSupport) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)coroutineSupport, (String)"coroutineSupport");
            super(element, coroutineSupport, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/AbstractChangeFeatureSupportLevelFix$FeatureSupportIntentionActionsFactory;", "()V", "shortFeatureName", "", "getShortFeatureName", "()Ljava/lang/String;", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getFixText", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "kotlin.jvm"})
    public static final class Companion
    extends AbstractChangeFeatureSupportLevelFix.FeatureSupportIntentionActionsFactory {
        private final String getShortFeatureName() {
            return KotlinJvmBundle.message("short.feature.name.coroutine", new Object[0]);
        }

        @NotNull
        public final String getFixText(@NotNull LanguageFeature.State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return AbstractChangeFeatureSupportLevelFix.Companion.getFixText(state, this.getShortFeatureName());
        }

        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)diagnostic.getPsiElement());
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026nt) ?: return emptyList()");
            Module module2 = module;
            return this.doCreateActions(diagnostic, LanguageFeature.Coroutines, true, this.shouldConfigureInProject(module2) ? (Function3)doCreateActions.1.INSTANCE : (Function3)doCreateActions.2.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

