/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

public class KotlinTestNgConfigurationProducer
extends TestNGConfigurationProducer {
    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(TestNGConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context) {
        String vmParameters;
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration(this.getConfigurationType());
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)location.getProject()).getConfigurationTemplate(this.getConfigurationFactory());
        Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)template.getConfiguration()).getConfigurationModule()).getModule();
        String string = vmParameters = predefinedConfiguration instanceof CommonJavaRunConfigurationParameters ? ((CommonJavaRunConfigurationParameters)predefinedConfiguration).getVMParameters() : null;
        if (vmParameters != null && !Comparing.strEqual((String)vmParameters, (String)configuration.getVMParameters())) {
            return false;
        }
        if (this.differentParamSet((JavaTestConfigurationBase)configuration, contextLocation)) {
            return false;
        }
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(element);
        if (declarationToRun == null) {
            return false;
        }
        PsiNamedElement lightElement = (PsiNamedElement)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightElements((KtElement)declarationToRun));
        if (lightElement != null && configuration.isConfiguredByElement((PsiElement)lightElement)) {
            Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Project project = context.getProject();
        PsiElement leaf = location.getPsiElement();
        if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)leaf, (boolean)false)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        KtFile ktFile = (KtFile)leaf.getContainingFile();
        if (!JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetector.getPlatform((KtFile)ktFile))) {
            return false;
        }
        Pair<PsiClass, PsiMethod> classAndMethod = KotlinTestNgConfigurationProducer.getTestClassAndMethod(leaf);
        if (classAndMethod == null) {
            return false;
        }
        PsiClass testClass = (PsiClass)classAndMethod.getFirst();
        if (testClass == null) {
            return false;
        }
        PsiMethod testMethod = (PsiMethod)classAndMethod.getSecond();
        return this.configure(configuration, location, context, project, testClass, testMethod);
    }

    public void onFirstRun(ConfigurationFromContext configuration, ConfigurationContext context, Runnable startRunnable) {
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(configuration.getSourceElement());
        final PsiNamedElement lightElement = (PsiNamedElement)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightElements((KtElement)declarationToRun));
        if (lightElement instanceof PsiMethod || lightElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (lightElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)lightElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)lightElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ((TestNGConfiguration)context.getConfiguration().getConfiguration()).bePatternConfiguration(classes, method);
                    super.runForClasses(classes, method, context, performRunnable);
                }

                protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    if (lightElement instanceof PsiMethod) {
                        Project project = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project, psiMethod, PsiLocation.fromPsiElement((PsiElement)aClass));
                        ((TestNGConfiguration)context.getConfiguration().getConfiguration()).setMethodConfiguration((Location)methodLocation);
                    } else {
                        ((TestNGConfiguration)context.getConfiguration().getConfiguration()).setClassConfiguration(aClass);
                    }
                    super.runForClass(aClass, psiMethod, context, performRunnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(context, startRunnable, psiMethod, containingClass, (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass aClass) {
                    return aClass.hasModifierProperty("abstract") && TestNGUtil.hasTest((PsiModifierListOwner)aClass);
                }
            })) {
                return;
            }
        }
        super.onFirstRun(configuration, context, startRunnable);
    }

    @Nullable
    private static KtNamedDeclaration getDeclarationToRun(@NotNull PsiElement leaf) {
        if (leaf == null) {
            KotlinTestNgConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return null;
        }
        KtFile jetFile = (KtFile)leaf.getContainingFile();
        KtNamedFunction function = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtNamedFunction.class, (boolean)false);
        if (function != null) {
            return function;
        }
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtClass.class, (boolean)false);
        if (ktClass != null) {
            return ktClass;
        }
        return KotlinTestNgConfigurationProducer.getClassDeclarationInFile(jetFile);
    }

    private boolean configure(TestNGConfiguration configuration, Location location, ConfigurationContext context, Project project, @Nullable PsiClass delegate, @Nullable PsiMethod method) {
        if (delegate == null) {
            return false;
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.setClassConfiguration(delegate);
        if (method != null) {
            configuration.setMethodConfiguration(PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
        }
        configuration.restoreOriginalModule(originalModule);
        configuration.setName(configuration.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    private static boolean isTestNGClass(PsiClass psiClass) {
        return psiClass != null && PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)false) && TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
    }

    @Nullable
    static KtClass getClassDeclarationInFile(KtFile jetFile) {
        KtClass tempSingleDeclaration = null;
        for (KtDeclaration ktDeclaration : jetFile.getDeclarations()) {
            if (!(ktDeclaration instanceof KtClass)) continue;
            KtClass declaration = (KtClass)ktDeclaration;
            if (tempSingleDeclaration == null) {
                tempSingleDeclaration = declaration;
                continue;
            }
            return null;
        }
        return tempSingleDeclaration;
    }

    @Nullable
    public static Pair<PsiClass, PsiMethod> getTestClassAndMethod(@NotNull PsiElement leaf) {
        KtLightClass delegate;
        KtLightClass delegate2;
        KtNamedFunction function;
        KtElement owner;
        KtNamedDeclaration declarationToRun;
        if (leaf == null) {
            KotlinTestNgConfigurationProducer.$$$reportNull$$$0(1);
        }
        if ((declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(leaf)) instanceof KtNamedFunction && (owner = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)(function = (KtNamedFunction)declarationToRun), (Class[])new Class[]{KtFunction.class, KtClass.class})) instanceof KtClass && (delegate2 = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClass)owner))) != null) {
            for (PsiMethod method : delegate2.getMethods()) {
                if (method.getNavigationElement() != function) continue;
                if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) break;
                return new Pair((Object)delegate2, (Object)method);
            }
        }
        if (declarationToRun instanceof KtClass && KotlinTestNgConfigurationProducer.isTestNGClass((PsiClass)(delegate = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declarationToRun))))) {
            return new Pair((Object)delegate, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "leaf";
        objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinTestNgConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclarationToRun";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestClassAndMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

