/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ui.SplitEditorToolbar;

public class TextEditorWithPreview
extends UserDataHolderBase
implements FileEditor {
    protected final TextEditor myEditor;
    protected final FileEditor myPreview;
    @NotNull
    private final MyListenersMultimap myListenersGenerator;
    private Layout myLayout;
    private JComponent myComponent;
    private SplitEditorToolbar myToolbarWrapper;
    private final String myName;

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview, @NotNull String editorName) {
        if (editor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            TextEditorWithPreview.$$$reportNull$$$0(1);
        }
        if (editorName == null) {
            TextEditorWithPreview.$$$reportNull$$$0(2);
        }
        this.myListenersGenerator = new MyListenersMultimap();
        this.myEditor = editor;
        this.myPreview = preview;
        this.myName = editorName;
    }

    public TextEditorWithPreview(@NotNull TextEditor editor, @NotNull FileEditor preview) {
        if (editor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(3);
        }
        if (preview == null) {
            TextEditorWithPreview.$$$reportNull$$$0(4);
        }
        this(editor, preview, "TextEditorWithPreview");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
        Disposer.dispose((Disposable)this.myPreview);
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
        this.myPreview.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
        this.myPreview.deselectNotify();
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            JBSplitter splitter = new JBSplitter(false, 0.5f, 0.15f, 0.85f);
            splitter.setSplitterProportionKey(this.getSplitterProportionKey());
            splitter.setFirstComponent(this.myEditor.getComponent());
            splitter.setSecondComponent(this.myPreview.getComponent());
            splitter.setDividerWidth(3);
            this.myToolbarWrapper = this.createMarkdownToolbarWrapper((JComponent)splitter);
            Disposer.register((Disposable)this, (Disposable)this.myToolbarWrapper);
            if (this.myLayout == null) {
                String lastUsed = PropertiesComponent.getInstance().getValue(this.getLayoutPropertyName());
                this.setLayout(Layout.fromName(lastUsed, Layout.SHOW_EDITOR_AND_PREVIEW));
            }
            this.adjustEditorsVisibility();
            this.myComponent = JBUI.Panels.simplePanel((Component)splitter).addToTop((Component)this.myToolbarWrapper);
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            TextEditorWithPreview.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @NotNull
    private SplitEditorToolbar createMarkdownToolbarWrapper(@NotNull JComponent targetComponentForActions) {
        ActionToolbar leftToolbar;
        if (targetComponentForActions == null) {
            TextEditorWithPreview.$$$reportNull$$$0(6);
        }
        if ((leftToolbar = this.createToolbar()) != null) {
            leftToolbar.setTargetComponent(targetComponentForActions);
            leftToolbar.setReservePlaceAutoPopupIcon(false);
        }
        ActionToolbar rightToolbar = this.createRightToolbar();
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        return new SplitEditorToolbar(leftToolbar, rightToolbar);
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TextEditorWithPreview.$$$reportNull$$$0(7);
        }
        if (state instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state;
            if (compositeState.getFirstState() != null) {
                this.myEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.myPreview.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.setLayout(compositeState.getSplitLayout());
                this.invalidateLayout();
            }
        }
    }

    private void adjustEditorsVisibility() {
        this.myEditor.getComponent().setVisible(this.myLayout == Layout.SHOW_EDITOR || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
        this.myPreview.getComponent().setVisible(this.myLayout == Layout.SHOW_PREVIEW || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    private void invalidateLayout() {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        JComponent focusComponent = this.getPreferredFocusedComponent();
        if (focusComponent != null) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    @NotNull
    protected String getSplitterProportionKey() {
        return "TextEditorWithPreview.SplitterProportionKey";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        switch (this.myLayout) {
            case SHOW_EDITOR_AND_PREVIEW: 
            case SHOW_EDITOR: {
                return this.myEditor.getPreferredFocusedComponent();
            }
            case SHOW_PREVIEW: {
                return this.myPreview.getPreferredFocusedComponent();
            }
        }
        throw new IllegalStateException(this.myLayout.myName);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TextEditorWithPreview.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TextEditorWithPreview.$$$reportNull$$$0(9);
        }
        return new MyFileEditorState(this.myLayout, this.myEditor.getState(level), this.myPreview.getState(level));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(10);
        }
        this.myEditor.addPropertyChangeListener(listener2);
        this.myPreview.addPropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.addListenerAndGetDelegate(listener2);
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)delegate);
        this.myPreview.addPropertyChangeListener((PropertyChangeListener)delegate);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(11);
        }
        this.myEditor.removePropertyChangeListener(listener2);
        this.myPreview.removePropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate = this.myListenersGenerator.removeListenerAndGetDelegate(listener2);
        if (delegate != null) {
            this.myEditor.removePropertyChangeListener((PropertyChangeListener)delegate);
            this.myPreview.removePropertyChangeListener((PropertyChangeListener)delegate);
        }
    }

    @NotNull
    public TextEditor getTextEditor() {
        TextEditor textEditor = this.myEditor;
        if (textEditor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(12);
        }
        return textEditor;
    }

    public Layout getLayout() {
        return this.myLayout;
    }

    protected void setLayout(@NotNull Layout layout) {
        if (layout == null) {
            TextEditorWithPreview.$$$reportNull$$$0(13);
        }
        this.myLayout = layout;
    }

    public boolean isModified() {
        return this.myEditor.isModified() || this.myPreview.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid() && this.myPreview.isValid();
    }

    @Nullable
    protected ActionToolbar createToolbar() {
        ActionGroup actionGroup = this.createLeftToolbarActionGroup();
        if (actionGroup != null) {
            return ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", actionGroup, true);
        }
        return null;
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return null;
    }

    @NotNull
    private ActionToolbar createRightToolbar() {
        ActionGroup viewActions = this.createViewActionGroup();
        ActionGroup group = this.createRightToolbarActionGroup();
        ActionGroup rightToolbarActions = group == null ? viewActions : new DefaultActionGroup(new AnAction[]{group, Separator.create(), viewActions});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", rightToolbarActions, true);
        if (actionToolbar == null) {
            TextEditorWithPreview.$$$reportNull$$$0(14);
        }
        return actionToolbar;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        return new DefaultActionGroup(new AnAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction(), this.getShowPreviewAction()});
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return null;
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR);
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_PREVIEW);
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    @NotNull
    private String getLayoutPropertyName() {
        String string = this.myName + "Layout";
        if (string == null) {
            TextEditorWithPreview.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorName";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponentForActions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRightToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMarkdownToolbarWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChangeViewModeAction
    extends ToggleAction
    implements DumbAware {
        private final Layout myActionLayout;

        ChangeViewModeAction(Layout layout) {
            super(layout.getName(), layout.getName(), layout.getIcon());
            this.myActionLayout = layout;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewModeAction.$$$reportNull$$$0(0);
            }
            return TextEditorWithPreview.this.myLayout == this.myActionLayout;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ChangeViewModeAction.$$$reportNull$$$0(1);
            }
            if (state) {
                TextEditorWithPreview.this.setLayout(this.myActionLayout);
                PropertiesComponent.getInstance().setValue(TextEditorWithPreview.this.getLayoutPropertyName(), TextEditorWithPreview.this.myLayout.myName, Layout.SHOW_EDITOR_AND_PREVIEW.myName);
                TextEditorWithPreview.this.adjustEditorsVisibility();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview$ChangeViewModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Layout {
        SHOW_EDITOR(KotlinJvmBundle.message("editor.editor.only", new Object[0]), AllIcons.General.LayoutEditorOnly),
        SHOW_PREVIEW(KotlinJvmBundle.message("editor.preview.only", new Object[0]), AllIcons.General.LayoutPreviewOnly),
        SHOW_EDITOR_AND_PREVIEW(KotlinJvmBundle.message("editor.editor.and.preview", new Object[0]), AllIcons.General.LayoutEditorPreview);

        private final String myName;
        private final Icon myIcon;

        private Layout(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public static Layout fromName(String name, Layout defaultValue) {
            for (Layout layout : Layout.values()) {
                if (!layout.myName.equals(name)) continue;
                return layout;
            }
            return defaultValue;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(0);
            }
            if (!this.myMap.containsKey(listener2)) {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener2)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener2);
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            DoublingEventListenerDelegate doublingEventListenerDelegate = (DoublingEventListenerDelegate)this.myMap.get(listener2).getSecond();
            if (doublingEventListenerDelegate == null) {
                MyListenersMultimap.$$$reportNull$$$0(1);
            }
            return doublingEventListenerDelegate;
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair;
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(2);
            }
            if ((oldPair = this.myMap.get(listener2)) == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener2);
            } else {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addListenerAndGetDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addListenerAndGetDelegate";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListenerAndGetDelegate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate) {
            if (delegate == null) {
                DoublingEventListenerDelegate.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)TextEditorWithPreview.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/scratch/ui/TextEditorWithPreview$DoublingEventListenerDelegate", "<init>"));
        }
    }

    static class MyFileEditorState
    implements FileEditorState {
        private final Layout mySplitLayout;
        private final FileEditorState myFirstState;
        private final FileEditorState mySecondState;

        MyFileEditorState(Layout layout, FileEditorState firstState, FileEditorState secondState) {
            this.mySplitLayout = layout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public Layout getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }
    }
}

