/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.FieldNameConstantsFieldProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FieldNameConstantsOldProcessor
extends AbstractClassProcessor {
    public FieldNameConstantsOldProcessor() {
        super((Class<? extends PsiElement>)PsiField.class, "lombok.experimental.FieldNameConstants");
    }

    private FieldNameConstantsFieldProcessor getFieldNameConstantsFieldProcessor() {
        return (FieldNameConstantsFieldProcessor)ApplicationManager.getApplication().getService(FieldNameConstantsFieldProcessor.class);
    }

    @Override
    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(0);
        }
        return null != psiAnnotation.findAttributeValue("prefix");
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        boolean result;
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(3);
        }
        boolean bl = result = this.validateAnnotationOnRightType(psiClass, builder) && LombokProcessorUtil.isLevelVisible(psiAnnotation);
        if (result) {
            Collection<PsiField> psiFields = this.filterFields(psiClass);
            FieldNameConstantsFieldProcessor fieldProcessor = this.getFieldNameConstantsFieldProcessor();
            for (PsiField psiField : psiFields) {
                fieldProcessor.checkIfFieldNameIsValidAndWarn(psiAnnotation, psiField, builder);
            }
        }
        return result;
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(5);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            builder.addError("'@FieldNameConstants' is only supported on a class, enum or field type");
            result = false;
        }
        return result;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(7);
        }
        if (target == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(8);
        }
        Collection<PsiField> psiFields = this.filterFields(psiClass);
        FieldNameConstantsFieldProcessor fieldProcessor = this.getFieldNameConstantsFieldProcessor();
        for (PsiField psiField : psiFields) {
            if (!fieldProcessor.checkIfFieldNameIsValidAndWarn(psiAnnotation, psiField, ProblemEmptyBuilder.getInstance())) continue;
            target.add((PsiElement)fieldProcessor.createFieldNameConstant(psiField, psiClass, psiAnnotation));
        }
    }

    @NotNull
    private Collection<PsiField> filterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(9);
        }
        ArrayList<PsiField> psiFields = new ArrayList<PsiField>();
        FieldNameConstantsFieldProcessor fieldProcessor = this.getFieldNameConstantsFieldProcessor();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            boolean useField = true;
            PsiModifierList modifierList = psiField.getModifierList();
            if (null != modifierList) {
                useField = !modifierList.hasModifierProperty("static");
                useField &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
                useField &= !psiField.getName().startsWith("$");
            }
            if (!useField) continue;
            psiFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = psiFields;
        if (arrayList == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(11);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(12);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.filterFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.USAGE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/FieldNameConstantsOldProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/FieldNameConstantsOldProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterFields";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

