/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import de.plushnikov.intellij.plugin.util.PsiTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.core.handlers.Singulars;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSingularHandler
implements BuilderElementHandler {
    final String collectionQualifiedName;

    AbstractSingularHandler(String qualifiedName) {
        this.collectionQualifiedName = qualifiedName;
    }

    @Override
    public Collection<PsiField> renderBuilderFields(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(0);
        }
        PsiType builderFieldType = this.getBuilderFieldType(info.getFieldType(), info.getProject());
        return Collections.singleton(new LombokLightFieldBuilder(info.getManager(), info.getFieldName(), builderFieldType).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
    }

    @NotNull
    protected PsiType getBuilderFieldType(@NotNull PsiType psiFieldType, @NotNull Project project) {
        if (psiFieldType == null) {
            AbstractSingularHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractSingularHandler.$$$reportNull$$$0(2);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiType elementType = PsiTypeUtil.extractOneElementType(psiFieldType, psiManager);
        PsiType psiType = PsiTypeUtil.createCollectionType(psiManager, "java.util.ArrayList", elementType);
        if (psiType == null) {
            AbstractSingularHandler.$$$reportNull$$$0(3);
        }
        return psiType;
    }

    @Override
    public Collection<PsiMethod> renderBuilderMethod(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(4);
        }
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        PsiType returnType = info.getBuilderType();
        String fieldName = info.getFieldName();
        String singularName = this.createSingularName(info.getSingularAnnotation(), fieldName);
        PsiClass builderClass = info.getBuilderClass();
        LombokLightMethodBuilder oneAddMethodBuilder = new LombokLightMethodBuilder(info.getManager(), LombokUtils.buildAccessorName(info.getSetterPrefix(), singularName)).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations());
        this.addOneMethodParameter(oneAddMethodBuilder, info.getFieldType(), singularName);
        String oneMethodBody = this.getOneMethodBody(singularName, info);
        oneAddMethodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(oneMethodBody, (PsiElement)oneAddMethodBuilder));
        methods.add((PsiMethod)oneAddMethodBuilder);
        LombokLightMethodBuilder allAddMethodBuilder = new LombokLightMethodBuilder(info.getManager(), LombokUtils.buildAccessorName(info.getSetterPrefix(), fieldName)).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations());
        this.addAllMethodParameter(allAddMethodBuilder, info.getFieldType(), fieldName);
        String allMethodBody = this.getAllMethodBody(fieldName, info);
        allAddMethodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(allMethodBody, (PsiElement)allAddMethodBuilder));
        methods.add((PsiMethod)allAddMethodBuilder);
        LombokLightMethodBuilder clearMethodBuilder = new LombokLightMethodBuilder(info.getManager(), this.createSingularClearMethodName(fieldName)).withContainingClass(builderClass).withMethodReturnType(returnType).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations());
        String clearMethodBlockText = this.getClearMethodBody(info);
        clearMethodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(clearMethodBlockText, (PsiElement)clearMethodBuilder));
        methods.add((PsiMethod)clearMethodBuilder);
        return methods;
    }

    @NotNull
    private String createSingularClearMethodName(String fieldName) {
        String string = "clear" + StringUtil.capitalize((String)fieldName);
        if (string == null) {
            AbstractSingularHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public List<String> getBuilderMethodNames(@NotNull String fieldName, @Nullable PsiAnnotation singularAnnotation) {
        if (fieldName == null) {
            AbstractSingularHandler.$$$reportNull$$$0(6);
        }
        return Arrays.asList(this.createSingularName(singularAnnotation, fieldName), fieldName, this.createSingularClearMethodName(fieldName));
    }

    @Override
    public String renderToBuilderCall(@NotNull BuilderInfo info) {
        if (info == null) {
            AbstractSingularHandler.$$$reportNull$$$0(7);
        }
        String instanceGetter = info.getInstanceVariableName() + "." + info.getVariable().getName();
        return info.getFieldName() + "(" + instanceGetter + " == null ? " + this.getEmptyCollectionCall() + " : " + instanceGetter + ")";
    }

    protected abstract String getEmptyCollectionCall();

    protected abstract String getClearMethodBody(@NotNull BuilderInfo var1);

    protected abstract void addOneMethodParameter(@NotNull LombokLightMethodBuilder var1, @NotNull PsiType var2, @NotNull String var3);

    protected abstract void addAllMethodParameter(@NotNull LombokLightMethodBuilder var1, @NotNull PsiType var2, @NotNull String var3);

    protected abstract String getOneMethodBody(@NotNull String var1, @NotNull BuilderInfo var2);

    protected abstract String getAllMethodBody(@NotNull String var1, @NotNull BuilderInfo var2);

    @Override
    public String createSingularName(@NotNull PsiAnnotation singularAnnotation, String psiFieldName) {
        String singularName;
        if (singularAnnotation == null) {
            AbstractSingularHandler.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)(singularName = PsiAnnotationUtil.getStringAnnotationValue(singularAnnotation, "value"))) && (singularName = Singulars.autoSingularize((String)psiFieldName)) == null) {
            singularName = psiFieldName;
        }
        return singularName;
    }

    public static boolean validateSingularName(PsiAnnotation singularAnnotation, String psiFieldName) {
        String singularName = PsiAnnotationUtil.getStringAnnotationValue(singularAnnotation, "value");
        if (StringUtil.isEmptyOrSpaces((String)singularName)) {
            singularName = Singulars.autoSingularize((String)psiFieldName);
            return singularName != null;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFieldType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/singular/AbstractSingularHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singularAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/AbstractSingularHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderFieldType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingularClearMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderBuilderFields";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFieldType";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderBuilderMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderMethodNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderToBuilderCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSingularName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

