/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;

public class DelegatesToInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitAnnotation(@NotNull GrAnnotation annotation) {
                if (annotation == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkTarget(annotation);
                this.checkDelegatesTo(annotation);
            }

            private void checkTarget(GrAnnotation annotation) {
                if (!"groovy.lang.DelegatesTo.Target".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiElement owner = annotation.getParent().getParent();
                if (!(owner instanceof GrParameter)) {
                    return;
                }
                boolean isTargetDeclared = annotation.findDeclaredAttributeValue("value") != null;
                String targetName = GrAnnotationUtil.inferStringAttribute(annotation, "value");
                GrParameterList parameterList = (GrParameterList)owner.getParent();
                for (GrParameter parameter : parameterList.getParameters()) {
                    String curTarget;
                    PsiAnnotation delegatesTo = parameter.getModifierList().findAnnotation("groovy.lang.DelegatesTo");
                    if (delegatesTo == null || !(isTargetDeclared ? (curTarget = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target")) != null && curTarget.equals(targetName) : delegatesTo.findDeclaredAttributeValue("target") == null && delegatesTo.findDeclaredAttributeValue("value") == null)) continue;
                    return;
                }
                this.registerError((PsiElement)annotation.getClassReference(), GroovyBundle.message("target.annotation.is.unused", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private void checkDelegatesTo(GrAnnotation annotation) {
                if (!"groovy.lang.DelegatesTo".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiElement owner = annotation.getParent().getParent();
                if (!(owner instanceof GrParameter)) {
                    return;
                }
                PsiAnnotationMemberValue targetPair = annotation.findDeclaredAttributeValue("target");
                if (targetPair == null) {
                    return;
                }
                String targetName = GrAnnotationUtil.inferStringAttribute(annotation, "target");
                GrParameterList parameterList = (GrParameterList)owner.getParent();
                for (GrParameter parameter : parameterList.getParameters()) {
                    String curTarget;
                    PsiAnnotation target = parameter.getModifierList().findAnnotation("groovy.lang.DelegatesTo.Target");
                    if (target == null || (curTarget = GrAnnotationUtil.inferStringAttribute(target, "value")) == null || !curTarget.equals(targetName)) continue;
                    return;
                }
                this.registerError((PsiElement)targetPair, GroovyBundle.message("target.0.does.not.exist", targetName != null ? targetName : "?"), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/codeInspection/confusing/DelegatesToInspection$1", "visitAnnotation"));
            }
        };
    }
}

