/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GroovyPointlessArithmeticInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("pointless.arithmetic.error.message", GroovyPointlessArithmeticInspection.calculateReplacementExpression((GrExpression)args[0]));
    }

    private static String calculateReplacementExpression(GrExpression expression) {
        GrBinaryExpression exp = (GrBinaryExpression)expression;
        IElementType sign = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        GrExpression rhs = exp.getRightOperand();
        assert (rhs != null);
        if (GroovyTokenTypes.mPLUS == sign) {
            if (GroovyPointlessArithmeticInspection.isZero(lhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (GroovyTokenTypes.mMINUS == sign) {
            return lhs.getText();
        }
        if (GroovyTokenTypes.mSTAR == sign) {
            if (GroovyPointlessArithmeticInspection.isOne(lhs)) {
                return rhs.getText();
            }
            if (GroovyPointlessArithmeticInspection.isOne(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (GroovyTokenTypes.mDIV == sign) {
            return lhs.getText();
        }
        return "";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyPointlessArithmeticInspection.$$$reportNull$$$0(0);
        }
        return new PointlessArithmeticFix();
    }

    private static boolean subtractionExpressionIsPointless(GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(rhs);
    }

    private static boolean additionExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(lhs) || GroovyPointlessArithmeticInspection.isZero(rhs);
    }

    private static boolean multiplyExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isZero(lhs) || GroovyPointlessArithmeticInspection.isZero(rhs) || GroovyPointlessArithmeticInspection.isOne(lhs) || GroovyPointlessArithmeticInspection.isOne(rhs);
    }

    private static boolean divideExpressionIsPointless(GrExpression rhs) {
        return GroovyPointlessArithmeticInspection.isOne(rhs);
    }

    private static boolean isZero(GrExpression expression) {
        PsiElement inner = PsiUtil.skipParentheses(expression, false);
        if (inner == null) {
            return false;
        }
        @NonNls String text = inner.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text) || "0b0".equals(text) || "0B0".equals(text);
    }

    private static boolean isOne(GrExpression expression) {
        PsiElement inner = PsiUtil.skipParentheses(expression, false);
        if (inner == null) {
            return false;
        }
        @NonNls String text = inner.getText();
        return "1".equals(text) || "0x1".equals(text) || "0X1".equals(text) || "1.0".equals(text) || "1L".equals(text) || "1l".equals(text) || "0b0".equals(text) || "0B0".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessArithmeticInspection", "buildFix"));
    }

    private static class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private final TokenSet arithmeticTokens = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mPLUS, GroovyTokenTypes.mMINUS, GroovyTokenTypes.mSTAR, GroovyTokenTypes.mDIV});

        private PointlessArithmeticVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                PointlessArithmeticVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (PsiUtilKt.isFake(expression)) {
                return;
            }
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!this.arithmeticTokens.contains(sign)) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            boolean isPointless = sign.equals(GroovyTokenTypes.mPLUS) ? GroovyPointlessArithmeticInspection.additionExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mMINUS) ? GroovyPointlessArithmeticInspection.subtractionExpressionIsPointless(rhs) : (sign.equals(GroovyTokenTypes.mSTAR) ? GroovyPointlessArithmeticInspection.multiplyExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mDIV) ? GroovyPointlessArithmeticInspection.divideExpressionIsPointless(rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessArithmeticInspection$PointlessArithmeticVisitor", "visitBinaryExpression"));
        }
    }

    private static class PointlessArithmeticFix
    extends GroovyFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.simplify", new Object[0]);
            if (string == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(2);
            }
            GrExpression expression = (GrExpression)descriptor.getPsiElement();
            String newExpression = GroovyPointlessArithmeticInspection.calculateReplacementExpression(expression);
            PointlessArithmeticFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessArithmeticInspection$PointlessArithmeticFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessArithmeticInspection$PointlessArithmeticFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

