/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;

public class LiteralConstructorSearcher {
    private final PsiMethod myConstructor;
    private final Processor<? super PsiReference> myConsumer;
    private final boolean myIncludeOverloads;

    public LiteralConstructorSearcher(PsiMethod constructor, Processor<? super PsiReference> consumer, boolean includeOverloads) {
        this.myConstructor = constructor;
        this.myConsumer = consumer;
        this.myIncludeOverloads = includeOverloads;
    }

    public boolean processLiteral(GrListOrMap literal) {
        GroovyConstructorReference reference = literal.getConstructorReference();
        return reference == null || !this.isCorrectReference(reference) || this.myConsumer.process((Object)reference);
    }

    private boolean isCorrectReference(GroovyConstructorReference reference) {
        if (reference.isReferenceTo((PsiElement)this.myConstructor)) {
            return true;
        }
        if (!this.myIncludeOverloads) {
            return false;
        }
        GroovyResolveResult classResult = reference.resolveClass();
        if (classResult == null) {
            return false;
        }
        return this.myConstructor.getManager().areElementsEquivalent((PsiElement)this.myConstructor.getContainingClass(), classResult.getElement());
    }
}

