/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrArgumentListImpl
extends GroovyPsiElementImpl
implements GrArgumentList,
PsiListLikeElement {
    public GrArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrArgumentListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrArgumentListImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitArgumentList(this);
    }

    public String toString() {
        return "Arguments";
    }

    @Override
    public GrNamedArgument @NotNull [] getNamedArguments() {
        ArrayList<GrNamedArgument> result2 = new ArrayList<GrNamedArgument>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrNamedArgument)) continue;
            result2.add((GrNamedArgument)cur);
        }
        GrNamedArgument[] grNamedArgumentArray = result2.toArray(GrNamedArgument.EMPTY_ARRAY);
        if (grNamedArgumentArray == null) {
            GrArgumentListImpl.$$$reportNull$$$0(2);
        }
        return grNamedArgumentArray;
    }

    @Override
    public GrNamedArgument findNamedArgument(@NotNull String label) {
        if (label == null) {
            GrArgumentListImpl.$$$reportNull$$$0(3);
        }
        return PsiImplUtil.findNamedArgument(this, label);
    }

    @Override
    public GrExpression @NotNull [] getExpressionArguments() {
        ArrayList<GrExpression> result2 = new ArrayList<GrExpression>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            result2.add((GrExpression)cur);
        }
        GrExpression[] grExpressionArray = result2.toArray(GrExpression.EMPTY_ARRAY);
        if (grExpressionArray == null) {
            GrArgumentListImpl.$$$reportNull$$$0(4);
        }
        return grExpressionArray;
    }

    @Override
    public GroovyPsiElement @NotNull [] getAllArguments() {
        ArrayList<GroovyPsiElement> args = new ArrayList<GroovyPsiElement>();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GrNamedArgument) && !(child instanceof GrExpression)) continue;
            args.add((GroovyPsiElement)child);
        }
        GroovyPsiElement[] groovyPsiElementArray = args.toArray(GroovyPsiElement.EMPTY_ARRAY);
        if (groovyPsiElementArray == null) {
            GrArgumentListImpl.$$$reportNull$$$0(5);
        }
        return groovyPsiElementArray;
    }

    @Override
    public GrArgumentList replaceWithArgumentList(GrArgumentList newArgList) throws IncorrectOperationException {
        if (this.getParent() == null || this.getParent().getNode() == null) {
            throw new IncorrectOperationException();
        }
        ASTNode parentNode = this.getParent().getNode();
        ASTNode newNode = newArgList.getNode();
        assert (parentNode != null);
        parentNode.replaceChild(this.getNode(), newNode);
        if (!(newNode.getPsi() instanceof GrArgumentList)) {
            throw new IncorrectOperationException();
        }
        return (GrArgumentList)newNode.getPsi();
    }

    @Override
    @Nullable
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mLPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mRPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    public int getExpressionArgumentIndex(GrExpression arg) {
        int res = 0;
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            if (arg == cur) {
                return res;
            }
            ++res;
        }
        return -1;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) {
        GrNamedArgument[] namedArguments = this.getNamedArguments();
        GrExpression[] args = this.getExpressionArguments();
        GroovyPsiElement anchor = null;
        int namedCount = namedArguments.length;
        int exprCount = args.length;
        if (namedCount > 0) {
            anchor = namedArguments[namedCount - 1];
        } else if (exprCount > 0) {
            anchor = args[exprCount - 1];
        }
        anchor = anchor != null ? PsiUtil.getNextNonSpace(anchor) : this.getRightParen();
        this.addBefore(namedArgument, anchor);
        return namedArgument;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrArgumentListImpl.$$$reportNull$$$0(6);
        }
        return this.addBefore(element, null);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            GrArgumentListImpl.$$$reportNull$$$0(7);
        }
        if (element instanceof GrNamedArgument || element instanceof GrExpression) {
            if (anchor == null) {
                anchor = this.getLastChild();
            }
            if (anchor == null) {
                return super.addBefore(element, anchor);
            }
            for (anchor = anchor.getPrevSibling(); anchor != null && !(anchor instanceof GrExpression) && !(anchor instanceof GrNamedArgument); anchor = anchor.getPrevSibling()) {
            }
            return this.addAfter(element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            GrArgumentListImpl.$$$reportNull$$$0(8);
        }
        if (element instanceof GrExpression || element instanceof GrNamedArgument) {
            boolean insertComma;
            boolean bl = insertComma = this.getAllArguments().length != 0;
            if (anchor == null) {
                anchor = this.getLeftParen();
            }
            PsiElement result2 = super.addAfter(element, anchor);
            if (insertComma) {
                ASTNode astNode = this.getNode();
                if (anchor == this.getLeftParen()) {
                    astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result2.getNextSibling().getNode());
                } else {
                    astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result2.getNode());
                }
                CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat((PsiElement)this);
            }
            return result2;
        }
        return super.addAfter(element, anchor);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement element;
        if (child == null) {
            GrArgumentListImpl.$$$reportNull$$$0(9);
        }
        if ((element = child.getPsi()) instanceof GrExpression || element instanceof GrNamedArgument) {
            ASTNode prev = TreeUtil.skipElementsBack((ASTNode)child.getTreePrev(), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS);
            if (prev != null && prev.getElementType() == GroovyTokenTypes.mCOMMA) {
                ASTNode pprev = prev.getTreePrev();
                if (pprev != null && PsiImplUtil.isWhiteSpaceOrNls(pprev)) {
                    super.deleteChildInternal(pprev);
                }
                super.deleteChildInternal(prev);
            } else {
                ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS);
                if (next != null && next.getElementType() == GroovyTokenTypes.mCOMMA) {
                    ASTNode nnext = next.getTreeNext();
                    if (nnext != null && PsiImplUtil.isWhiteSpaceOrNls(nnext)) {
                        super.deleteChildInternal(nnext);
                    }
                    super.deleteChildInternal(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    public PsiExpression @NotNull [] getExpressions() {
        if (PsiExpression.EMPTY_ARRAY == null) {
            GrArgumentListImpl.$$$reportNull$$$0(10);
        }
        return PsiExpression.EMPTY_ARRAY;
    }

    public PsiType @NotNull [] getExpressionTypes() {
        if (PsiType.EMPTY_ARRAY == null) {
            GrArgumentListImpl.$$$reportNull$$$0(11);
        }
        return PsiType.EMPTY_ARRAY;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<GroovyPsiElement> list = Arrays.asList(this.getAllArguments());
        if (list == null) {
            GrArgumentListImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllArguments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findNamedArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

