/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    @NotNull
    private static final Key<Boolean> PREDEFINED_ENUM_METHOD = Key.create((String)"PREDEFINED_ENUM_METHOD");

    public GrEnumTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, (IStubElementType)GroovyStubElementTypes.ENUM_TYPE_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.createEnumType()};
        if (psiClassTypeArray == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(1);
        }
        return psiClassTypeArray;
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass("java.lang.Enum", this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor);
        }
        return TypesUtil.createTypeByFQClassName("java.lang.Enum", this);
    }

    @ApiStatus.Internal
    public List<PsiMethod> getDefEnumMethods(@NotNull TransformationContext context) {
        if (context == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(2);
        }
        PsiManagerEx manager = this.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiClassType thisType = context.eraseClassType(factory.createType((PsiClass)this, PsiSubstitutor.EMPTY));
        List<PsiMethod> result2 = Arrays.asList(new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "values").setMethodReturnType((PsiType)new PsiArrayType((PsiType)thisType)).setContainingClass((PsiClass)this).addModifier("public").addModifier("static"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "next").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "previous").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "valueOf").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addParameter("name", "java.lang.String").addModifier("public").addModifier("static"));
        for (PsiMethod method : result2) {
            method.putUserData(PREDEFINED_ENUM_METHOD, (Object)true);
        }
        return result2;
    }

    public boolean isPredefinedEnumMethod(@NotNull PsiMethod method) {
        if (method == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(3);
        }
        return method.getUserData(PREDEFINED_ENUM_METHOD) != null;
    }

    @Override
    public GrEnumConstant @NotNull [] getEnumConstants() {
        GrEnumDefinitionBody body = this.getBody();
        GrEnumConstant[] grEnumConstantArray = body == null ? GrEnumConstant.EMPTY_ARRAY : body.getEnumConstants();
        if (grEnumConstantArray == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(4);
        }
        return grEnumConstantArray;
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        return enumDefinitionBody == null ? null : enumDefinitionBody.getEnumConstantList();
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(5);
        }
        visitor2.visitEnumDefinition(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        GrEnumConstant[] constants;
        if (psiElement == null) {
            GrEnumTypeDefinitionImpl.$$$reportNull$$$0(6);
        }
        if (!(psiElement instanceof GrEnumConstant)) {
            return super.add(psiElement);
        }
        GrEnumDefinitionBody body = this.getBody();
        assert (body != null);
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null && (constants = list.getEnumConstants()).length > 0) {
            list.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
            list.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", null);
            return list.add(psiElement);
        }
        PsiElement brace = body.getLBrace();
        return body.addAfter(psiElement, brace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumConstants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefEnumMethods";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedEnumMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

