/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;

final class LocalVarAnalyzer
extends GroovyRecursiveElementVisitor {
    private final Set<PsiVariable> touched = new HashSet<PsiVariable>();
    private final Set<PsiVariable> rewritten = new HashSet<PsiVariable>();
    private final TObjectIntHashMap<PsiVariable> allVars = new TObjectIntHashMap();
    private int grade = 0;

    public static Result searchForVarsToWrap(GroovyPsiElement root, Result analyzedVars, ExpressionContext context) {
        LocalVarAnalyzer visitor2 = new LocalVarAnalyzer();
        root.accept(visitor2);
        HashMap<PsiVariable, String> varToName = analyzedVars == null ? new HashMap() : analyzedVars.varToName;
        HashSet<PsiVariable> toWrap = analyzedVars == null ? new HashSet() : analyzedVars.toWrap;
        HashSet<PsiVariable> toMakeFinal = analyzedVars == null ? new HashSet() : analyzedVars.toMakeFinal;
        for (PsiVariable v : visitor2.touched) {
            if (visitor2.rewritten.contains(v)) {
                toWrap.add(v);
                if (v instanceof PsiParameter) {
                    varToName.put(v, GenerationUtil.suggestVarName(v.getType(), root, context));
                    continue;
                }
                varToName.put(v, v.getName());
                continue;
            }
            toMakeFinal.add(v);
            varToName.put(v, v.getName());
        }
        return analyzedVars == null ? new Result(toMakeFinal, toWrap, varToName) : analyzedVars;
    }

    public static Result initialResult() {
        return new Result(new HashSet<PsiVariable>(), new HashSet<PsiVariable>(), new HashMap<PsiVariable, String>());
    }

    private LocalVarAnalyzer() {
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            LocalVarAnalyzer.$$$reportNull$$$0(0);
        }
        ++this.grade;
        super.visitClosure(closure);
        --this.grade;
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            LocalVarAnalyzer.$$$reportNull$$$0(1);
        }
        if (!(typeDefinition instanceof PsiAnonymousClass)) {
            return;
        }
        ++this.grade;
        super.visitTypeDefinition(typeDefinition);
        --this.grade;
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            LocalVarAnalyzer.$$$reportNull$$$0(2);
        }
        super.visitVariable(variable);
        if (variable instanceof GrField) {
            return;
        }
        this.allVars.put((Object)variable, this.grade);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            LocalVarAnalyzer.$$$reportNull$$$0(3);
        }
        super.visitReferenceExpression(ref);
        PsiElement resolved = ref.resolve();
        if (!this.allVars.contains((Object)resolved)) {
            return;
        }
        GrVariable var = (GrVariable)resolved;
        if (PsiUtil.isAccessedForWriting(ref)) {
            this.rewritten.add(var);
        }
        if (this.allVars.get((Object)var) < this.grade) {
            this.touched.add((PsiVariable)resolved);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/LocalVarAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClosure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Result {
        private final Set<PsiVariable> toMakeFinal;
        private final Set<PsiVariable> toWrap;
        private final Map<PsiVariable, String> varToName;

        private Result(Set<PsiVariable> toMakeFinal, Set<PsiVariable> toWrap, Map<PsiVariable, String> varToName) {
            this.toMakeFinal = toMakeFinal;
            this.toWrap = toWrap;
            this.varToName = varToName;
        }

        boolean toWrap(PsiVariable variable) {
            return this.toWrap.contains(variable);
        }

        boolean toMakeFinal(PsiVariable variable) {
            return this.toMakeFinal.contains(variable);
        }

        String toVarName(PsiVariable variable) {
            return this.varToName.get(variable);
        }
    }
}

