/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.BasicShape;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Ellipse
extends BasicShape
implements DrawOperation {
    protected int width = 0;
    protected int height = 0;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public PlanarImage executeDrawOperation() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = bi.createGraphics();
        if (!"transparent".equalsIgnoreCase(this.stroke)) {
            BasicStroke bStroke = new BasicStroke(this.stroke_width);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            graphics.draw(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        if (!"transparent".equalsIgnoreCase(this.fill)) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            graphics.fill(new Ellipse2D.Double(0.0, 0.0, this.width, this.height));
        }
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                PlanarImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img.getAsBufferedImage(), null, 0, 0);
                continue;
            }
            if (!(instr instanceof TransformOperation)) continue;
            PlanarImage image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
            bi = image.getAsBufferedImage();
            graphics = bi.createGraphics();
        }
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

