/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.ResourceHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ZipHandler
extends ZipHandlerBase {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @Override
        @NotNull
        protected ZipFile createAccessor(ZipHandler handler2) throws IOException {
            String canonicalPathToZip = handler2.getCanonicalPathToZip();
            ZipHandler.setFileAttributes(handler2, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        @Override
        protected void disposeAccessor(@NotNull ZipFile fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(0);
            }
            fileAccessor.close();
        }

        @Override
        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "com/intellij/openapi/vfs/impl/ZipHandler$1", "disposeAccessor"));
        }
    };

    public ZipHandler(@NotNull String path2) {
        if (path2 == null) {
            ZipHandler.$$$reportNull$$$0(0);
        }
        super(path2);
    }

    protected static synchronized void setFileAttributes(@NotNull ZipHandler zipHandler, @NotNull String pathToZip) {
        FileAttributes attributes;
        if (zipHandler == null) {
            ZipHandler.$$$reportNull$$$0(1);
        }
        if (pathToZip == null) {
            ZipHandler.$$$reportNull$$$0(2);
        }
        zipHandler.myFileStamp = (attributes = FileSystemUtil.getAttributes(pathToZip)) != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    private static synchronized boolean isSameFileAttributes(@NotNull ZipHandler zipHandler, @NotNull FileAttributes attributes) {
        if (zipHandler == null) {
            ZipHandler.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            ZipHandler.$$$reportNull$$$0(4);
        }
        return attributes.lastModified == zipHandler.myFileStamp && attributes.length == zipHandler.myFileLength;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value2 = this.myCanonicalPathToZip;
        if (value2 == null) {
            this.myCanonicalPathToZip = value2 = this.getFileToUse().getCanonicalPath();
        }
        String string2 = value2;
        if (string2 == null) {
            ZipHandler.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle<ZipFile> handle2;
            FileAccessorCache.Handle<ZipFile> handle3 = handle2 = createIfNeeded ? ourZipFileFileAccessorCache.get(this) : ourZipFileFileAccessorCache.getIfCached(this);
            if (handle2 != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes(this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (ZipHandler.isSameFileAttributes(this, attributes)) {
                    return handle2;
                }
                this.clearCaches();
                handle2.release();
                handle2 = ourZipFileFileAccessorCache.get(this);
            }
            return handle2;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Override
    protected void clearCaches() {
        ourZipFileFileAccessorCache.remove(this);
        super.clearCaches();
    }

    @NotNull
    protected File getFileToUse() {
        File file2 = this.getFile();
        if (file2 == null) {
            ZipHandler.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        FileAccessorCache.Handle<ZipFile> handle2 = this.getCachedZipFileHandle(true);
        if (handle2 == null) {
            ZipHandler.$$$reportNull$$$0(7);
        }
        return handle2;
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToZip";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPathToZip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUse";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireZipHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFileAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSameFileAttributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

