/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComponentCallBuilder;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0086\b\u00f8\u0001\u0000\u001a/\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0014\u001a\n\u0010\u001f\u001a\u00020\u0002*\u00020\u001e\u001a\n\u0010 \u001a\u00020\u0011*\u00020\u0014\u001a\u0016\u0010!\u001a\u00020\"*\u0004\u0018\u00010\u001e2\b\b\u0002\u0010#\u001a\u00020\u001e\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"expressionSet", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "qualifiedAccessTokens", "Lcom/intellij/psi/tree/TokenSet;", "getQualifiedAccessTokens", "()Lcom/intellij/psi/tree/TokenSet;", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "isClassLocal", "classNode", "Lcom/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "stubMode", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;Z)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "getAsStringWithoutBacktick", "", "getOperationSymbol", "isExpression", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "light-tree2fir"})
public final class ConverterUtilKt {
    private static final List<IElementType> expressionSet = CollectionsKt.listOf(KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN);
    @NotNull
    private static final TokenSet qualifiedAccessTokens;

    @NotNull
    public static final TokenSet getQualifiedAccessTokens() {
        return qualifiedAccessTokens;
    }

    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkNotNullParameter(defaultName, "defaultName");
        if ($this$nameAsSafeName != null) {
            Name name2 = Name.identifier(StringsKt.replace$default($this$nameAsSafeName, "`", "", false, 4, null));
            name = name2;
            Intrinsics.checkNotNullExpressionValue(name2, "Name.identifier(this.replace(\"`\", \"\"))");
        } else {
            CharSequence charSequence = defaultName;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Name name3 = Name.identifier(defaultName);
                name = name3;
                Intrinsics.checkNotNullExpressionValue(name3, "Name.identifier(defaultName)");
            } else {
                Name name4 = SpecialNames.NO_NAME_PROVIDED;
                name = name4;
                Intrinsics.checkNotNullExpressionValue(name4, "SpecialNames.NO_NAME_PROVIDED");
            }
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkNotNullParameter($this$getOperationSymbol, "$this$getOperationSymbol");
        TokenSet tokenSet = KotlinExpressionParsing.ALL_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "KotlinExpressionParsing.ALL_OPERATIONS");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkNotNullExpressionValue(iElementTypeArray, "KotlinExpressionParsing.ALL_OPERATIONS.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            IElementType element$iv;
            IElementType it = element$iv = iElementTypeArray2[i];
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual(((KtSingleValueToken)it).getValue(), $this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual($this$getOperationSymbol, "as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkNotNullExpressionValue(ktToken, "KtTokens.AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue(ktToken, "KtTokens.IDENTIFIER");
        return ktToken;
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter($this$getAsStringWithoutBacktick, "$this$getAsStringWithoutBacktick");
        return StringsKt.replace$default($this$getAsStringWithoutBacktick.toString(), "`", "", false, 4, null);
    }

    public static final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter($this$isExpression, "$this$isExpression");
        IElementType iElementType = $this$isExpression.getTokenType();
        return iElementType instanceof KtNodeType || iElementType instanceof KtConstantExpressionElementType || iElementType instanceof KtStringTemplateExpressionElementType || expressionSet.contains(iElementType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container, boolean stubMode) {
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, "$this$extractArgumentsFrom");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!stubMode || $this$extractArgumentsFrom instanceof FirAnnotationCallBuilder) {
            void $this$buildArgumentList;
            boolean $i$f$buildArgumentList = false;
            boolean bl = false;
            FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder;
            T t = $this$extractArgumentsFrom;
            boolean bl4 = false;
            Collection collection = $this$buildArgumentList.getArguments();
            Iterable iterable = container;
            boolean bl5 = false;
            CollectionsKt.addAll(collection, iterable);
            Unit unit = Unit.INSTANCE;
            t.setArgumentList(firArgumentListBuilder.build());
        }
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        int $i$f$isClassLocal = 0;
        Intrinsics.checkNotNullParameter(classNode, "classNode");
        Intrinsics.checkNotNullParameter(getParent, "getParent");
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode parent2 = getParent.invoke(currentNode);
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.PROPERTY) || Intrinsics.areEqual(tokenType, KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode = parent2;
                LighterASTNode grandParent = lighterASTNode != null ? getParent.invoke(lighterASTNode) : null;
                LighterASTNode lighterASTNode2 = parent2;
                if (Intrinsics.areEqual(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null, KtNodeTypes.KT_FILE)) {
                    return true;
                }
                LighterASTNode lighterASTNode3 = parent2;
                if (Intrinsics.areEqual(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null, KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (!Intrinsics.areEqual(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null, KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode4 = grandParent) != null && (lighterASTNode4 = getParent.invoke(lighterASTNode4)) != null ? lighterASTNode4.getTokenType() : null, KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                LighterASTNode lighterASTNode6 = parent2;
                if (Intrinsics.areEqual(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null, KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode7 = grandParent;
                    if (Intrinsics.areEqual(lighterASTNode7 != null ? lighterASTNode7.getTokenType() : null, KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Intrinsics.checkNotNullParameter(container, "container");
        boolean $i$f$buildBlock = false;
        boolean bl = false;
        FirBlockBuilder firBlockBuilder = new FirBlockBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBlockBuilder $this$buildBlock = firBlockBuilder;
        boolean bl4 = false;
        if (tmpVariable) {
            Collection collection = $this$buildBlock.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl5 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl6 = false;
        for (FirVariable entry : (Iterable)multiDeclaration.getEntries()) {
            void index2;
            void $this$buildComponentCall;
            Collection collection = $this$buildBlock.getStatements();
            boolean $i$f$buildProperty = false;
            boolean bl7 = false;
            FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
            boolean bl8 = false;
            boolean bl9 = false;
            FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
            boolean bl10 = false;
            $this$buildProperty.setSession(session);
            $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$buildProperty.setReturnTypeRef(entry.getReturnTypeRef());
            $this$buildProperty.setName(entry.getName());
            boolean $i$f$buildComponentCall = false;
            boolean bl11 = false;
            Object object = new FirComponentCallBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            FirComponentCallBuilder firComponentCallBuilder = object;
            FirPropertyBuilder firPropertyBuilder2 = $this$buildProperty;
            boolean bl14 = false;
            $this$buildComponentCall.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(null, container));
            $this$buildComponentCall.setComponentIndex((int)(index2 + true));
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2.setInitializer(((FirComponentCallBuilder)object).build());
            $this$buildProperty.setVar(isVar);
            $this$buildProperty.setSymbol(new FirPropertySymbol(entry.getName()));
            $this$buildProperty.setLocal(true);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue(visibility, "Visibilities.LOCAL");
            $this$buildProperty.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            Collection collection2 = $this$buildProperty.getAnnotations();
            object = entry.getAnnotations();
            bl12 = false;
            CollectionsKt.addAll(collection2, object);
            FirProperty firProperty = firPropertyBuilder.build();
            bl7 = false;
            collection.add(firProperty);
            ++index2;
        }
        return firBlockBuilder.build();
    }

    static {
        TokenSet tokenSet = TokenSet.create(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        qualifiedAccessTokens = tokenSet;
    }
}

