/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    @NotNull
    private final DecoratorManager myManager;
    @NotNull
    private final SvnMergeInfoCache myMergeInfoCache;
    @NotNull
    private final RootsAndBranches myMainPanel;
    @NotNull
    private final SvnMergeInfoRootPanelManual myPanel;
    @NotNull
    private final Map<Pair<WCInfo, Url>, MergeInfoCached> myCachedMap;

    public MergeInfoHolder(@NotNull Project project, @NotNull DecoratorManager manager, @NotNull RootsAndBranches mainPanel, @NotNull SvnMergeInfoRootPanelManual panel) {
        if (project == null) {
            MergeInfoHolder.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MergeInfoHolder.$$$reportNull$$$0(1);
        }
        if (mainPanel == null) {
            MergeInfoHolder.$$$reportNull$$$0(2);
        }
        if (panel == null) {
            MergeInfoHolder.$$$reportNull$$$0(3);
        }
        this.myManager = manager;
        this.myMainPanel = mainPanel;
        this.myPanel = panel;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = new HashMap<Pair<WCInfo, Url>, MergeInfoCached>();
    }

    @NotNull
    private Pair<WCInfo, Url> getCacheKey() {
        Pair pair = Pair.create((Object)this.myPanel.getWcInfo(), (Object)this.myPanel.getBranch().getUrl());
        if (pair == null) {
            MergeInfoHolder.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Nullable
    private MergeInfoCached getCurrentCache() {
        return this.myCachedMap.get(this.getCacheKey());
    }

    private boolean isEnabledAndConfigured(boolean ignoreEnabled) {
        return (ignoreEnabled || this.myMainPanel.isHighlightingOn() && this.myPanel.isEnabled()) && this.myPanel.getBranch() != null && this.myPanel.getLocalBranch() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.isEnabledAndConfigured(ignoreEnabled) && this.getCurrentCache() == null;
    }

    @NotNull
    public ListMergeStatus refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists(refresher);
        }
        this.myManager.repaintTree();
        ListMergeStatus listMergeStatus = ListMergeStatus.REFRESHING;
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(5);
        }
        return listMergeStatus;
    }

    @Nullable
    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        MyRefresher result = null;
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            this.myCachedMap.put(this.getCacheKey(), state != null ? state.copy() : new MergeInfoCached());
            this.myMergeInfoCache.clear(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = new MyRefresher();
        }
        return result;
    }

    @NotNull
    public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
        ListMergeStatus result;
        if (!this.isEnabledAndConfigured(ignoreEnabled) || !(list instanceof SvnChangeList)) {
            result = ListMergeStatus.ALIEN;
        } else {
            MergeInfoCached cachedState = this.getCurrentCache();
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = cachedState != null ? this.check(list, cachedState, true) : (state != null ? this.check(list, state, false) : this.refresh(ignoreEnabled));
        }
        ListMergeStatus listMergeStatus = result;
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(6);
        }
        return listMergeStatus;
    }

    @NotNull
    public ListMergeStatus check(@NotNull CommittedChangeList list, @NotNull MergeInfoCached state, boolean isCached) {
        if (list == null) {
            MergeInfoHolder.$$$reportNull$$$0(7);
        }
        if (state == null) {
            MergeInfoHolder.$$$reportNull$$$0(8);
        }
        MergeCheckResult mergeCheckResult = state.getMap().get(list.getNumber());
        ListMergeStatus result = state.copiedAfter(list) ? ListMergeStatus.COMMON : ListMergeStatus.from(mergeCheckResult);
        ListMergeStatus listMergeStatus = (ListMergeStatus)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)(isCached ? ListMergeStatus.REFRESHING : ListMergeStatus.ALIEN))));
        if (listMergeStatus == null) {
            MergeInfoHolder.$$$reportNull$$$0(9);
        }
        return listMergeStatus;
    }

    public void updateMixedRevisionsForPanel() {
        this.myPanel.setMixedRevisions(this.myMergeInfoCache.isMixedRevisions(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyRefresher
    implements CommittedChangeListsListener {
        @NotNull
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = MergeInfoHolder.this.myPanel.getWcInfo();
            this.myRefreshedBranch = MergeInfoHolder.this.myPanel.getBranch();
            this.myBranchPath = MergeInfoHolder.this.myPanel.getLocalBranch();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(@NotNull CommittedChangeList list) {
            if (list == null) {
                MyRefresher.$$$reportNull$$$0(0);
            }
            if (list instanceof SvnChangeList) {
                MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(() -> {
                    MergeInfoCached cachedState = MergeInfoHolder.this.myCachedMap.get(this.getCacheKey());
                    if (cachedState != null) {
                        cachedState.getMap().put(number, checkState);
                    }
                    MergeInfoHolder.this.myManager.repaintTree();
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(() -> {
                MergeInfoHolder.this.myCachedMap.remove(this.getCacheKey());
                MergeInfoHolder.this.updateMixedRevisionsForPanel();
                MergeInfoHolder.this.myManager.repaintTree();
            });
        }

        @NotNull
        private Pair<WCInfo, Url> getCacheKey() {
            Pair pair = Pair.create((Object)this.myRefreshedRoot, (Object)this.myRefreshedBranch.getUrl());
            if (pair == null) {
                MyRefresher.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder$MyRefresher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder$MyRefresher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCacheKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "report";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

