/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public final class ArrayFrob {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new ConcurrentHashMap();

    public static Map<Class<?>, Class<?>> getPrimitiveToWrapperTypes() {
        return Collections.unmodifiableMap(PRIMITIVE_TO_WRAPPER);
    }

    public static Map<Class<?>, Class<?>> getWrapperToPrimitiveTypes() {
        return Collections.unmodifiableMap(WRAPPER_TO_PRIMITIVE);
    }

    private ArrayFrob() {
    }

    public static <T> T[] wrap(Object o) throws IllegalArgumentException {
        Class<?> ac = o.getClass();
        if (!ac.isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        Class<?> cc = ac.getComponentType();
        Class<?> ncc = PRIMITIVE_TO_WRAPPER.get(cc);
        if (null == ncc) {
            throw new IllegalArgumentException("Not a primitive type");
        }
        Object[] ns = (Object[])Array.newInstance(ncc, Array.getLength(o));
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Array.get(o, i);
        }
        return ns;
    }

    public static <T> Object unwrap(T[] ns) throws IllegalArgumentException {
        Class<?> ac = ns.getClass();
        Class<?> cc = ac.getComponentType();
        Class<?> ncc = WRAPPER_TO_PRIMITIVE.get(cc);
        if (null == ncc) {
            throw new IllegalArgumentException("Not a wrapper type");
        }
        Object o = Array.newInstance(ncc, ns.length);
        for (int i = 0; i < ns.length; ++i) {
            Array.set(o, i, ns[i]);
        }
        return o;
    }

    public static <T> List<T> listify(T[] ns) throws IllegalArgumentException {
        return Arrays.asList(ns);
    }

    public static <T> List<T> listify(Object o) throws IllegalArgumentException {
        if (o instanceof Object[]) {
            return ArrayFrob.listify((Object[])o);
        }
        if (!o.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        ArrayList<Object> l = new ArrayList<Object>(Array.getLength(o));
        for (int i = 0; i < Array.getLength(o); ++i) {
            l.add(Array.get(o, i));
        }
        return l;
    }

    public static <T> T[] delist(List<T> l, Class<T> c) throws IllegalArgumentException {
        return l.toArray((Object[])Array.newInstance(c, 0));
    }

    public static <T> Object delistprimitive(List<T> l, Class<T> c) throws IllegalArgumentException {
        Object o = Array.newInstance(c, l.size());
        for (int i = 0; i < l.size(); ++i) {
            Array.set(o, i, l.get(i));
        }
        return o;
    }

    public static Object convert(Object o, Class<? extends Object> c) throws IllegalArgumentException {
        try {
            if (List.class.equals(c) && o instanceof List) {
                return o;
            }
            if (List.class.equals(c) && o.getClass().isArray()) {
                return ArrayFrob.listify(o);
            }
            if (o.getClass().isArray() && c.isArray() && o.getClass().getComponentType().equals(c.getComponentType())) {
                return o;
            }
            if (o.getClass().isArray() && c.isArray() && o.getClass().getComponentType().isPrimitive()) {
                return ArrayFrob.wrap(o);
            }
            if (o.getClass().isArray() && c.isArray() && c.getComponentType().isPrimitive()) {
                return ArrayFrob.unwrap((Object[])o);
            }
            if (o instanceof List && c.isArray() && c.getComponentType().isPrimitive()) {
                return ArrayFrob.delistprimitive((List)o, c.getComponentType());
            }
            if (o instanceof List && c.isArray()) {
                return ArrayFrob.delist((List)o, c.getComponentType());
            }
            if (o.getClass().isArray() && c.isArray()) {
                return ArrayFrob.type((Object[])o, c.getComponentType());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ArrayFrob.class).debug("Cannot convert object.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException(String.format("Not An Expected Convertion type from %s to %s", o.getClass(), c));
    }

    public static Object[] type(Object[] old, Class<Object> c) {
        Object[] ns = (Object[])Array.newInstance(c, old.length);
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = old[i];
        }
        return ns;
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
    }
}

