/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class ShStringUtil {
    private static final char[] ORIGIN_CHARS = new char[]{' ', '!', '\"', '#', '$', '&', '\'', '(', ')', '*', ',', ';', '<', '>', '=', '?', '[', '\\', ']', '^', '`', '{', '|', '}'};
    public static final Set<Character> ORIGINS_SET = IntStream.range(0, ORIGIN_CHARS.length).mapToObj(i -> Character.valueOf(ORIGIN_CHARS[i])).collect(Collectors.toSet());
    private static final List<String> ENCODED = ShStringUtil.toStr(ORIGIN_CHARS, Character.valueOf('\\'));
    private static final List<String> ORIGINS = ShStringUtil.toStr(ORIGIN_CHARS, null);

    private static List<String> toStr(char[] arr, Character prefix) {
        return IntStream.range(0, arr.length).mapToObj(i -> {
            String v = String.valueOf(arr[i]);
            return prefix != null ? prefix + v : v;
        }).collect(Collectors.toList());
    }

    @NotNull
    public static String quote(String name) {
        String string = StringUtil.replace((String)name, ORIGINS, ENCODED);
        if (string == null) {
            ShStringUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String unquote(String afterSlash) {
        String string = StringUtil.replace((String)afterSlash, ENCODED, ORIGINS);
        if (string == null) {
            ShStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sh/ShStringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

