/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.MetricStringDistance;
import java.util.HashMap;
import net.jcip.annotations.Immutable;

@Immutable
public class Damerau
implements MetricStringDistance {
    public final double distance(String s1, String s2) {
        int i;
        int d;
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        int inf = s1.length() + s2.length();
        HashMap<Character, Integer> da = new HashMap<Character, Integer>();
        for (d = 0; d < s1.length(); ++d) {
            da.put(Character.valueOf(s1.charAt(d)), 0);
        }
        for (d = 0; d < s2.length(); ++d) {
            da.put(Character.valueOf(s2.charAt(d)), 0);
        }
        int[][] h = new int[s1.length() + 2][s2.length() + 2];
        for (i = 0; i <= s1.length(); ++i) {
            h[i + 1][0] = inf;
            h[i + 1][1] = i;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            h[0][j + 1] = inf;
            h[1][j + 1] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            int db = 0;
            for (int j = 1; j <= s2.length(); ++j) {
                int i1 = (Integer)da.get(Character.valueOf(s2.charAt(j - 1)));
                int j1 = db;
                int cost = 1;
                if (s1.charAt(i - 1) == s2.charAt(j - 1)) {
                    cost = 0;
                    db = j;
                }
                h[i + 1][j + 1] = Damerau.min(h[i][j] + cost, h[i + 1][j] + 1, h[i][j + 1] + 1, h[i1][j1] + (i - i1 - 1) + 1 + (j - j1 - 1));
            }
            da.put(Character.valueOf(s1.charAt(i - 1)), i);
        }
        return h[s1.length() + 1][s2.length() + 1];
    }

    private static int min(int a, int b, int c, int d) {
        return Math.min(a, Math.min(b, Math.min(c, d)));
    }
}

