/*
 * Decompiled with CFR 0.152.
 */
package training.ui.welcomeScreen;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.InteractiveCourseData;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.HeightLimitedPane;
import com.intellij.openapi.wm.impl.welcomeScreen.learnIde.LearnIdeContentColorsAndFonts;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import icons.FeaturesTrainerIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.interfaces.Module;
import training.statistic.StatisticBase;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Ltraining/ui/welcomeScreen/IFTInteractiveCourseData;", "Lcom/intellij/openapi/wm/InteractiveCourseData;", "()V", "getAction", "Ljavax/swing/Action;", "getActionButtonName", "", "getDescription", "getExpandContent", "Ljavax/swing/JComponent;", "getIcon", "Ljavax/swing/Icon;", "getName", "moduleDescription", "Lcom/intellij/openapi/wm/impl/welcomeScreen/learnIde/HeightLimitedPane;", "module", "Ltraining/learn/interfaces/Module;", "moduleHeader", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "openLearningFromWelcomeScreen", "", "rigid", "Ljava/awt/Component;", "_width", "", "_height", "intellij.featuresTrainer"})
public final class IFTInteractiveCourseData
implements InteractiveCourseData {
    @NotNull
    public String getName() {
        return LearnBundle.INSTANCE.message("welcome.tab.header.learn.ide.features", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return LearnBundle.INSTANCE.message("welcome.tab.description.learn.ide.features", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = FeaturesTrainerIcons.Img.PluginIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PluginIcon");
        return icon;
    }

    @NotNull
    public String getActionButtonName() {
        return LearnBundle.INSTANCE.message("welcome.tab.start.learning.button", new Object[0]);
    }

    @NotNull
    public Action getAction() {
        return new AbstractAction(this, LearnBundle.INSTANCE.message("welcome.tab.start.learning.button", new Object[0])){
            final /* synthetic */ IFTInteractiveCourseData this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                IFTInteractiveCourseData.access$openLearningFromWelcomeScreen(this.this$0, null);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public JComponent getExpandContent() {
        List<Module> modules = CourseManager.Companion.getInstance().getModules();
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.rigid(16, 1));
        for (Module module : modules) {
            panel.add((Component)this.moduleHeader(module));
            panel.add(this.rigid(2, 2));
            panel.add((Component)this.moduleDescription(module));
            panel.add(this.rigid(16, 16));
        }
        panel.add(this.rigid(16, 15));
        StatisticBase.Companion.logWelcomeScreenPanelExpanded();
        return panel;
    }

    private final HeightLimitedPane moduleDescription(Module module) {
        String string = module.getDescription();
        if (string == null) {
            string = "";
        }
        return new HeightLimitedPane(string, -1, LearnIdeContentColorsAndFonts.INSTANCE.getModuleDescriptionColor(), false, null, 24, null);
    }

    private final LinkLabel<Object> moduleHeader(Module module) {
        LinkLabel<Object> linkLabel2 = new LinkLabel<Object>(module, module.getName(), null){
            final /* synthetic */ Module $module;

            public void setUI(@Nullable LabelUI ui) {
                super.setUI(ui);
                if (this.getFont() != null) {
                    Font font = this.getFont();
                    Font font2 = this.getFont();
                    Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
                    this.setFont(new FontUIResource(font.deriveFont(font2.getSize2D() + (float)JBUIScale.scale((int)-1) + (float)(SystemInfo.isWindows ? JBUIScale.scale((int)1) : 0))));
                }
            }
            {
                this.$module = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        linkLabel2.setName("linkLabel." + module.getName());
        linkLabel2.setListener((LinkListener)new LinkListener<Object>(this, module){
            final /* synthetic */ IFTInteractiveCourseData this$0;
            final /* synthetic */ Module $module;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                StatisticBase.Companion.logModuleStarted(this.$module);
                IFTInteractiveCourseData.access$openLearningFromWelcomeScreen(this.this$0, this.$module);
            }
            {
                this.this$0 = iFTInteractiveCourseData;
                this.$module = module;
            }
        }, null);
        return (LinkLabel)linkLabel2;
    }

    private final Component rigid(int _width, int _height) {
        Component component2 = Box.createRigidArea(new Dimension(JBUI.scale((int)_width), JBUI.scale((int)_height)));
        boolean bl = false;
        boolean bl2 = false;
        Component $this$apply = component2;
        boolean bl3 = false;
        Component component3 = $this$apply;
        if (component3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        ((JComponent)component3).setAlignmentX(0.0f);
        Component component4 = component2;
        Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"Box.createRigidArea(\n   \u2026nmentX = LEFT_ALIGNMENT }");
        return component4;
    }

    private final void openLearningFromWelcomeScreen(Module module) {
        AnAction action2 = ActionManager.getInstance().getAction("ShowLearnPanel");
        CourseManager courseManager = CourseManager.Companion.getInstance();
        Module module2 = module;
        if (module2 == null) {
            module2 = (Module)CollectionsKt.firstOrNull(CourseManager.Companion.getInstance().getModules());
        }
        courseManager.setUnfoldModuleOnInit(module2);
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"WelcomeScreen", (DataContext)DataContext.EMPTY_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026ataContext.EMPTY_CONTEXT)");
        AnActionEvent anActionEvent2 = anActionEvent;
        ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)anActionEvent2);
    }

    public static final /* synthetic */ void access$openLearningFromWelcomeScreen(IFTInteractiveCourseData $this, Module module) {
        $this.openLearningFromWelcomeScreen(module);
    }
}

