/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Set;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.dsl.ParsedModuleStringNotation;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class ModuleVersionSelectorParsers {
    private static final NotationParserBuilder<Object, ModuleVersionSelector> BUILDER = NotationParserBuilder.toType(ModuleVersionSelector.class).fromCharSequence(new StringConverter()).converter(new MapConverter());

    public static NotationParser<Object, Set<ModuleVersionSelector>> multiParser() {
        return ModuleVersionSelectorParsers.builder().toFlatteningComposite();
    }

    public static NotationParser<Object, ModuleVersionSelector> parser() {
        return ModuleVersionSelectorParsers.builder().toComposite();
    }

    private static NotationParserBuilder<Object, ModuleVersionSelector> builder() {
        return BUILDER;
    }

    static class StringConverter
    implements NotationConverter<String, ModuleVersionSelector> {
        StringConverter() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("String or CharSequence values").example("'org.gradle:gradle-core:1.0'");
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super ModuleVersionSelector> result) throws TypeConversionException {
            ParsedModuleStringNotation parsed;
            try {
                parsed = new ParsedModuleStringNotation(notation, null);
            }
            catch (IllegalDependencyNotation e) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. The correct notation is a 3-part group:name:version notation, e.g: 'org.gradle:gradle-core:1.0'");
            }
            if (parsed.getGroup() == null || parsed.getName() == null || parsed.getVersion() == null) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. Group, name and version cannot be empty. Correct example: 'org.gradle:gradle-core:1.0'");
            }
            result.converted(DefaultModuleVersionSelector.newSelector(DefaultModuleIdentifier.newId(parsed.getGroup(), parsed.getName()), parsed.getVersion()));
        }
    }

    static class MapConverter
    extends MapNotationConverter<ModuleVersionSelector> {
        MapConverter() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.gradle', name:'gradle-core', version: '1.0']");
        }

        protected ModuleVersionSelector parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return DefaultModuleVersionSelector.newSelector(DefaultModuleIdentifier.newId(group, name), version);
        }
    }
}

