/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.TransformationRegistrationFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultVariantTransformRegistry
implements VariantTransformRegistry {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final List<ArtifactTransformRegistration> transforms = Lists.newArrayList();
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final ServiceRegistry services;
    private final InstantiatorFactory instantiatorFactory;
    private final InstantiationScheme parametersInstantiationScheme;
    private final TransformationRegistrationFactory registrationFactory;
    private final IsolationScheme<TransformAction<?>, TransformParameters> isolationScheme = new IsolationScheme<TransformAction, TransformParameters.None>(TransformAction.class, TransformParameters.class, TransformParameters.None.class);

    public DefaultVariantTransformRegistry(InstantiatorFactory instantiatorFactory, ImmutableAttributesFactory immutableAttributesFactory, ServiceRegistry services, TransformationRegistrationFactory registrationFactory, InstantiationScheme parametersInstantiationScheme) {
        this.instantiatorFactory = instantiatorFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.services = services;
        this.registrationFactory = registrationFactory;
        this.parametersInstantiationScheme = parametersInstantiationScheme;
    }

    @Override
    public void registerTransform(Action<? super VariantTransform> registrationAction) {
        try {
            UntypedRegistration registration = this.instantiatorFactory.decorateLenient().newInstance(UntypedRegistration.class, this.immutableAttributesFactory, this.instantiatorFactory);
            registrationAction.execute(registration);
            DefaultVariantTransformRegistry.validateActionType(registration.actionType);
            try {
                DefaultVariantTransformRegistry.validateAttributes(registration);
                Object[] parameters = registration.getTransformParameters();
                ArtifactTransformRegistration finalizedRegistration = this.registrationFactory.create(registration.from.asImmutable(), registration.to.asImmutable(), registration.actionType, parameters);
                this.transforms.add(finalizedRegistration);
            }
            catch (Exception e) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Could not register artifact transform ");
                formatter.appendType(registration.actionType);
                formatter.append(" (from ");
                formatter.appendValue(registration.from);
                formatter.append(" to ");
                formatter.appendValue(registration.to);
                formatter.append(").");
                throw new VariantTransformConfigurationException(formatter.toString(), e);
            }
        }
        catch (VariantTransformConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException("Could not register artifact transform.", e);
        }
    }

    @Override
    public <T extends TransformParameters> void registerTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        try {
            Class parameterType = this.isolationScheme.parameterTypeFor(actionType);
            TransformParameters parameterObject = parameterType == null ? null : (TransformParameters)this.parametersInstantiationScheme.withServices(this.services).instantiator().newInstance(parameterType, new Object[0]);
            TypedRegistration registration = (TypedRegistration)Cast.uncheckedNonnullCast(this.instantiatorFactory.decorateLenient().newInstance(TypedRegistration.class, parameterObject, this.immutableAttributesFactory));
            registrationAction.execute(registration);
            this.register(registration, actionType, parameterObject);
        }
        catch (VariantTransformConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not register artifact transform ");
            formatter.appendType(actionType);
            formatter.append(".");
            throw new VariantTransformConfigurationException(formatter.toString(), e);
        }
    }

    private <T extends TransformParameters> void register(RecordingRegistration registration, Class<? extends TransformAction<?>> actionType, @Nullable T parameterObject) {
        DefaultVariantTransformRegistry.validateActionType(actionType);
        try {
            DefaultVariantTransformRegistry.validateAttributes(registration);
            ArtifactTransformRegistration finalizedRegistration = this.registrationFactory.create(registration.from.asImmutable(), registration.to.asImmutable(), actionType, parameterObject);
            this.transforms.add(finalizedRegistration);
        }
        catch (Exception e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not register artifact transform ");
            formatter.appendType(actionType);
            formatter.append(" (from ");
            formatter.appendValue(registration.from);
            formatter.append(" to ");
            formatter.appendValue(registration.to);
            formatter.append(").");
            throw new VariantTransformConfigurationException(formatter.toString(), e);
        }
    }

    private static <T> void validateActionType(@Nullable Class<T> actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("An artifact transform action type must be provided.");
        }
    }

    private static void validateAttributes(RecordingRegistration registration) {
        if (registration.to.isEmpty()) {
            throw new IllegalArgumentException("At least one 'to' attribute must be provided.");
        }
        if (registration.from.isEmpty()) {
            throw new IllegalArgumentException("At least one 'from' attribute must be provided.");
        }
        if (!registration.from.keySet().containsAll(registration.to.keySet())) {
            throw new IllegalArgumentException("Each 'to' attribute must be included as a 'from' attribute.");
        }
    }

    @Override
    public List<ArtifactTransformRegistration> getTransforms() {
        return this.transforms;
    }

    @NonExtensible
    public static class TypedRegistration<T extends TransformParameters>
    extends RecordingRegistration
    implements TransformSpec<T> {
        private final T parameterObject;

        public TypedRegistration(@Nullable T parameterObject, ImmutableAttributesFactory immutableAttributesFactory) {
            super(immutableAttributesFactory);
            this.parameterObject = parameterObject;
        }

        @Override
        public T getParameters() {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot query parameters for artifact transform without parameters.");
            }
            return this.parameterObject;
        }

        @Override
        public void parameters(Action<? super T> action) {
            if (this.parameterObject == null) {
                throw new IllegalStateException("Cannot configure parameters for artifact transform without parameters.");
            }
            action.execute(this.parameterObject);
        }
    }

    @NonExtensible
    public static class UntypedRegistration
    extends RecordingRegistration
    implements VariantTransform {
        private Action<? super ActionConfiguration> configAction;
        private final InstantiatorFactory instantiatorFactory;
        Class<? extends ArtifactTransform> actionType;

        public UntypedRegistration(ImmutableAttributesFactory immutableAttributesFactory, InstantiatorFactory instantiatorFactory) {
            super(immutableAttributesFactory);
            this.instantiatorFactory = instantiatorFactory;
        }

        @Override
        public void artifactTransform(Class<? extends ArtifactTransform> type) {
            this.artifactTransform(type, null);
        }

        @Override
        public void artifactTransform(Class<? extends ArtifactTransform> type, @Nullable Action<? super ActionConfiguration> config) {
            if (this.actionType != null) {
                throw new IllegalStateException("Only one ArtifactTransform may be provided for registration.");
            }
            this.actionType = type;
            this.configAction = config;
        }

        Object[] getTransformParameters() {
            if (this.configAction == null) {
                return NO_PARAMETERS;
            }
            ActionConfiguration config = this.instantiatorFactory.decorateLenient().newInstance(DefaultActionConfiguration.class, new Object[0]);
            this.configAction.execute(config);
            return config.getParams();
        }
    }

    public static abstract class RecordingRegistration {
        final AttributeContainerInternal from;
        final AttributeContainerInternal to;

        public RecordingRegistration(ImmutableAttributesFactory immutableAttributesFactory) {
            this.from = immutableAttributesFactory.mutable();
            this.to = immutableAttributesFactory.mutable();
        }

        public AttributeContainer getFrom() {
            return this.from;
        }

        public AttributeContainer getTo() {
            return this.to;
        }
    }
}

