/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.DisambiguationRuleChain;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.attributes.AttributeMatchException;
import org.gradle.api.internal.attributes.AttributeMatchingRules;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.internal.action.DefaultConfigurableRule;
import org.gradle.internal.action.DefaultConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

public class DefaultDisambiguationRuleChain<T>
implements DisambiguationRuleChain<T>,
DisambiguationRule<T> {
    private final List<Action<? super MultipleCandidatesDetails<T>>> rules = Lists.newArrayList();
    private final Instantiator instantiator;
    private final IsolatableFactory isolatableFactory;

    public DefaultDisambiguationRuleChain(Instantiator instantiator, IsolatableFactory isolatableFactory) {
        this.instantiator = instantiator;
        this.isolatableFactory = isolatableFactory;
    }

    @Override
    public void add(Class<? extends AttributeDisambiguationRule<T>> rule, Action<? super ActionConfiguration> configureAction) {
        this.rules.add(new InstantiatingAction(DefaultConfigurableRules.of(DefaultConfigurableRule.of(rule, configureAction, this.isolatableFactory)), this.instantiator, new ExceptionHandler(rule)));
    }

    @Override
    public void add(Class<? extends AttributeDisambiguationRule<T>> rule) {
        this.rules.add(new InstantiatingAction(DefaultConfigurableRules.of(DefaultConfigurableRule.of(rule)), this.instantiator, new ExceptionHandler(rule)));
    }

    @Override
    public void pickFirst(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, true);
        this.rules.add(rule);
    }

    @Override
    public void pickLast(Comparator<? super T> comparator) {
        Action<MultipleCandidatesDetails<? super T>> rule = AttributeMatchingRules.orderedDisambiguation(comparator, false);
        this.rules.add(rule);
    }

    @Override
    public void execute(MultipleCandidatesResult<T> details) {
        for (Action<MultipleCandidatesDetails<MultipleCandidatesResult<T>>> action : this.rules) {
            action.execute(details);
            if (!details.hasResult()) continue;
            return;
        }
    }

    @Override
    public boolean doesSomething() {
        return !this.rules.isEmpty();
    }

    private static class ExceptionHandler<T>
    implements InstantiatingAction.ExceptionHandler<MultipleCandidatesDetails<T>> {
        private final Class<? extends AttributeDisambiguationRule<T>> rule;

        private ExceptionHandler(Class<? extends AttributeDisambiguationRule<T>> rule) {
            this.rule = rule;
        }

        @Override
        public void handleException(MultipleCandidatesDetails<T> details, Throwable throwable) {
            TreeSet orderedValues = Sets.newTreeSet((Comparator)Ordering.usingToString());
            orderedValues.addAll(details.getCandidateValues());
            throw new AttributeMatchException(String.format("Could not select value from candidates %s using %s.", orderedValues, ModelType.of(this.rule).getDisplayName()), throwable);
        }
    }
}

