/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.tasks.InitBuild;

public class BuildInitPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        if (project.getParent() == null) {
            project.getTasks().register("init", InitBuild.class, initBuild -> {
                initBuild.setGroup("Build Setup");
                initBuild.setDescription("Initializes a new Gradle build.");
                File buildFile = project.getBuildFile();
                boolean hasSubProjects = !project.getSubprojects().isEmpty();
                initBuild.onlyIf(new InitBuildOnlyIfSpec(buildFile, hasSubProjects, project.getLayout(), initBuild.getLogger()));
                initBuild.dependsOn(new InitBuildDependsOnCallable(buildFile, hasSubProjects, project.getLayout()));
            });
        }
    }

    private static String reasonToSkip(File buildFile, ProjectLayout layout, boolean hasSubProjects) {
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            String buildFileName = dsl.fileNameFor("build");
            if (layout.getProjectDirectory().file(buildFileName).getAsFile().exists()) {
                return "The build file '" + buildFileName + "' already exists. Skipping build initialization.";
            }
            String settingsFileName = dsl.fileNameFor("settings");
            if (!layout.getProjectDirectory().file(settingsFileName).getAsFile().exists()) continue;
            return "The settings file '" + settingsFileName + "' already exists. Skipping build initialization.";
        }
        if (buildFile != null && buildFile.exists()) {
            return "The build file '" + buildFile.getName() + "' already exists. Skipping build initialization.";
        }
        if (hasSubProjects) {
            return "This Gradle project appears to be part of an existing multi-project Gradle build. Skipping build initialization.";
        }
        return null;
    }

    private static class InitBuildDependsOnCallable
    implements Callable<String> {
        private final File buildFile;
        private final boolean hasSubProjects;
        private final ProjectLayout layout;

        private InitBuildDependsOnCallable(File buildFile, boolean hasSubProjects, ProjectLayout layout) {
            this.buildFile = buildFile;
            this.hasSubProjects = hasSubProjects;
            this.layout = layout;
        }

        @Override
        public String call() {
            if (BuildInitPlugin.reasonToSkip(this.buildFile, this.layout, this.hasSubProjects) == null) {
                return "wrapper";
            }
            return null;
        }
    }

    private static class InitBuildOnlyIfSpec
    implements Spec<Task> {
        private final File buildFile;
        private final boolean hasSubProjects;
        private final ProjectLayout layout;
        private final Logger logger;

        private InitBuildOnlyIfSpec(File buildFile, boolean hasSubProjects, ProjectLayout layout, Logger logger) {
            this.buildFile = buildFile;
            this.hasSubProjects = hasSubProjects;
            this.layout = layout;
            this.logger = logger;
        }

        @Override
        public boolean isSatisfiedBy(Task element) {
            String skippedMsg = BuildInitPlugin.reasonToSkip(this.buildFile, this.layout, this.hasSubProjects);
            if (skippedMsg != null) {
                this.logger.warn(skippedMsg);
                return false;
            }
            return true;
        }
    }
}

