/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.File;

public class LockTimeoutException
extends RuntimeException {
    private final String lockDisplayName;
    private final String ownerPid;
    private final String requestingPid;
    private final String ownerOperation;
    private final String requestingOperation;
    private final File lockFile;

    public LockTimeoutException(String lockDisplayName, String ownerPid, String requestingPid, String ownerOperation, String requestingOperation, File lockFile) {
        super(String.format("Timeout waiting to lock %s. It is currently in use by another Gradle instance.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", lockDisplayName, ownerPid, requestingPid, ownerOperation, requestingOperation, lockFile));
        this.lockDisplayName = lockDisplayName;
        this.ownerPid = ownerPid;
        this.requestingPid = requestingPid;
        this.ownerOperation = ownerOperation;
        this.requestingOperation = requestingOperation;
        this.lockFile = lockFile;
    }

    public String getLockDisplayName() {
        return this.lockDisplayName;
    }

    public String getOwnerPid() {
        return this.ownerPid;
    }

    public String getRequestingPid() {
        return this.requestingPid;
    }

    public String getOwnerOperation() {
        return this.ownerOperation;
    }

    public String getRequestingOperation() {
        return this.requestingOperation;
    }

    public File getLockFile() {
        return this.lockFile;
    }
}

