/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.ivypublish;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.ivypublish.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModuleDescriptorWriter;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactPublisher
implements ArtifactPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactPublisher.class);
    private final LocalConfigurationMetadataBuilder dependenciesConverter;
    private final IvyModuleDescriptorWriter ivyModuleDescriptorWriter;

    public DefaultArtifactPublisher(LocalConfigurationMetadataBuilder dependenciesConverter, IvyModuleDescriptorWriter ivyModuleDescriptorWriter) {
        this.dependenciesConverter = dependenciesConverter;
        this.ivyModuleDescriptorWriter = ivyModuleDescriptorWriter;
    }

    @Override
    public void publish(Iterable<? extends PublicationAwareRepository> repositories, Module module, Configuration configuration, File descriptor) throws PublishException {
        DefaultIvyModulePublishMetadata publishMetaData;
        Set allConfigurations = (Set)Cast.uncheckedCast(configuration.getAll());
        Set configurationsToPublish = (Set)Cast.uncheckedCast(configuration.getHierarchy());
        if (descriptor != null) {
            publishMetaData = this.toPublishMetaData(module, allConfigurations, false);
            this.ivyModuleDescriptorWriter.write(publishMetaData, descriptor);
        }
        publishMetaData = this.toPublishMetaData(module, configurationsToPublish, true);
        if (descriptor != null) {
            DefaultIvyArtifactName artifact = new DefaultIvyArtifactName("ivy", "ivy", "xml");
            publishMetaData.addArtifact(artifact, descriptor);
        }
        for (PublicationAwareRepository publicationAwareRepository : repositories) {
            ModuleVersionPublisher publisher = publicationAwareRepository.createPublisher();
            LOGGER.info("Publishing to {}", (Object)publisher);
            publisher.publish(publishMetaData);
        }
    }

    private DefaultIvyModulePublishMetadata toPublishMetaData(Module module, Set<? extends ConfigurationInternal> configurations, boolean validateArtifacts) {
        ModuleComponentIdentifier id = DefaultModuleComponentIdentifier.newId(DefaultModuleIdentifier.newId(module.getGroup(), module.getName()), module.getVersion());
        DefaultIvyModulePublishMetadata publishMetaData = new DefaultIvyModulePublishMetadata(id, module.getStatus());
        this.addConfigurations(publishMetaData, configurations, validateArtifacts);
        return publishMetaData;
    }

    private void addConfigurations(DefaultIvyModulePublishMetadata metaData, Collection<? extends ConfigurationInternal> configurations, boolean validateArtifacts) {
        for (ConfigurationInternal configurationInternal : configurations) {
            BuildableLocalConfigurationMetadata configurationMetadata = this.addConfiguration(metaData, configurationInternal);
            this.dependenciesConverter.addDependenciesAndExcludes(configurationMetadata, configurationInternal);
            OutgoingVariant outgoingVariant = configurationInternal.convertToOutgoingVariant();
            for (PublishArtifact publishArtifact : outgoingVariant.getArtifacts()) {
                if (validateArtifacts && !this.isValidToPublish(publishArtifact)) continue;
                metaData.addArtifact(configurationInternal.getName(), publishArtifact);
            }
        }
    }

    private BuildableLocalConfigurationMetadata addConfiguration(DefaultIvyModulePublishMetadata metaData, ConfigurationInternal configuration) {
        configuration.preventFromFurtherMutation();
        return metaData.addConfiguration(configuration.getName(), (Set<String>)Configurations.getNames(configuration.getExtendsFrom()), configuration.isVisible(), configuration.isTransitive());
    }

    private boolean isValidToPublish(PublishArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile.isDirectory()) {
            throw new IllegalArgumentException("Cannot publish a directory (" + artifactFile + ")");
        }
        if (artifactFile.exists()) {
            return true;
        }
        DefaultIvyArtifactName ivyArtifactName = DefaultIvyArtifactName.forPublishArtifact(artifact);
        if (!this.isSigningArtifact(ivyArtifactName)) {
            throw new PublishException(String.format("Cannot publish artifact '%s' (%s) as it does not exist.", ivyArtifactName, artifactFile));
        }
        return false;
    }

    private boolean isSigningArtifact(IvyArtifactName artifact) {
        return artifact.getType().endsWith(".asc") || artifact.getType().endsWith(".sig");
    }
}

