/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.api.Describable;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DescriptiveChange;
import org.gradle.internal.execution.history.changes.PropertyDiffListener;
import org.gradle.internal.execution.history.changes.SortedMapDiffUtil;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public class PropertyChanges
implements ChangeContainer {
    private final ImmutableSortedMap<String, ?> previous;
    private final ImmutableSortedMap<String, ?> current;
    private final String title;
    private final Describable executable;

    protected PropertyChanges(ImmutableSortedMap<String, ?> previous, ImmutableSortedMap<String, ?> current, String title, Describable executable) {
        this.previous = previous;
        this.current = current;
        this.title = title;
        this.executable = executable;
    }

    @Override
    public boolean accept(final ChangeVisitor visitor) {
        return SortedMapDiffUtil.diff(this.previous, this.current, new PropertyDiffListener<String, Object, Object>(){

            @Override
            public boolean removed(String previousProperty) {
                return visitor.visitChange(new DescriptiveChange("%s property '%s' has been removed for %s", PropertyChanges.this.title, previousProperty, PropertyChanges.this.executable.getDisplayName()));
            }

            @Override
            public boolean added(String currentProperty) {
                return visitor.visitChange(new DescriptiveChange("%s property '%s' has been added for %s", PropertyChanges.this.title, currentProperty, PropertyChanges.this.executable.getDisplayName()));
            }

            @Override
            public boolean updated(String property, Object previous, Object current) {
                return true;
            }
        });
    }
}

