/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.config;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.config.LoggingConfigurer;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;

public class LoggingSystemAdapter
implements LoggingSourceSystem {
    private final LoggingConfigurer configurer;
    private boolean enabled;
    private LogLevel logLevel = LogLevel.LIFECYCLE;

    public LoggingSystemAdapter(LoggingConfigurer configurer) {
        this.configurer = configurer;
    }

    @Override
    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.enabled, this.logLevel);
    }

    @Override
    public LoggingSystem.Snapshot setLevel(LogLevel logLevel) {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (this.logLevel != logLevel) {
            this.logLevel = logLevel;
            if (this.enabled) {
                this.configurer.configure(logLevel);
            }
        }
        return snapshot;
    }

    @Override
    public LoggingSystem.Snapshot startCapture() {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (!this.enabled) {
            this.enabled = true;
            this.configurer.configure(this.logLevel);
        }
        return snapshot;
    }

    @Override
    public void restore(LoggingSystem.Snapshot state2) {
        SnapshotImpl snapshot = (SnapshotImpl)state2;
        this.logLevel = snapshot.level;
        this.enabled = snapshot.enabled;
        this.configurer.configure(this.logLevel);
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final boolean enabled;
        private final LogLevel level;

        SnapshotImpl(boolean enabled, LogLevel level) {
            this.enabled = enabled;
            this.level = level;
        }
    }
}

