/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.internal.impldep.com.amazonaws.AmazonClientException;
import org.gradle.internal.impldep.com.amazonaws.AmazonServiceException;
import org.gradle.internal.impldep.com.amazonaws.ClientConfiguration;
import org.gradle.internal.impldep.com.amazonaws.auth.BasicAWSCredentials;
import org.gradle.internal.impldep.com.amazonaws.auth.BasicSessionCredentials;
import org.gradle.internal.impldep.com.amazonaws.regions.Region;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3Client;
import org.gradle.internal.impldep.com.amazonaws.services.s3.S3ClientOptions;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CannedAccessControlList;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.GetObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectListing;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.PutObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3Object;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transport.aws.s3.S3ConnectionProperties;
import org.gradle.internal.resource.transport.aws.s3.S3RegionalResource;
import org.gradle.internal.resource.transport.aws.s3.S3ResourceResolver;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Client.class);
    private S3ResourceResolver resourceResolver = new S3ResourceResolver();
    private AmazonS3Client amazonS3Client;
    private final S3ConnectionProperties s3ConnectionProperties;

    public S3Client(AmazonS3Client amazonS3Client, S3ConnectionProperties s3ConnectionProperties) {
        this.s3ConnectionProperties = s3ConnectionProperties;
        this.amazonS3Client = amazonS3Client;
    }

    public S3Client(S3ConnectionProperties s3ConnectionProperties) {
        this.s3ConnectionProperties = s3ConnectionProperties;
        this.amazonS3Client = new AmazonS3Client(this.createConnectionProperties());
        this.setAmazonS3ConnectionEndpoint();
    }

    public S3Client(AwsCredentials awsCredentials, S3ConnectionProperties s3ConnectionProperties) {
        this.s3ConnectionProperties = s3ConnectionProperties;
        Object credentials = null;
        if (awsCredentials != null) {
            credentials = awsCredentials.getSessionToken() == null ? new BasicAWSCredentials(awsCredentials.getAccessKey(), awsCredentials.getSecretKey()) : new BasicSessionCredentials(awsCredentials.getAccessKey(), awsCredentials.getSecretKey(), awsCredentials.getSessionToken());
        }
        this.amazonS3Client = new AmazonS3Client(credentials, this.createConnectionProperties());
        this.setAmazonS3ConnectionEndpoint();
    }

    private void setAmazonS3ConnectionEndpoint() {
        S3ClientOptions.Builder clientOptionsBuilder = S3ClientOptions.builder();
        Optional<URI> endpoint = this.s3ConnectionProperties.getEndpoint();
        if (endpoint.isPresent()) {
            this.amazonS3Client.setEndpoint(((URI)endpoint.get()).toString());
            clientOptionsBuilder.setPathStyleAccess(true).disableChunkedEncoding();
        }
        this.amazonS3Client.setS3ClientOptions(clientOptionsBuilder.build());
    }

    private ClientConfiguration createConnectionProperties() {
        Optional<Integer> maxErrorRetryCount;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        Optional<HttpProxySettings.HttpProxy> proxyOptional = this.s3ConnectionProperties.getProxy();
        if (proxyOptional.isPresent()) {
            HttpProxySettings.HttpProxy proxy = (HttpProxySettings.HttpProxy)this.s3ConnectionProperties.getProxy().get();
            clientConfiguration.setProxyHost(proxy.host);
            clientConfiguration.setProxyPort(proxy.port);
            PasswordCredentials credentials = proxy.credentials;
            if (credentials != null) {
                clientConfiguration.setProxyUsername(credentials.getUsername());
                clientConfiguration.setProxyPassword(credentials.getPassword());
            }
        }
        if ((maxErrorRetryCount = this.s3ConnectionProperties.getMaxErrorRetryCount()).isPresent()) {
            clientConfiguration.setMaxErrorRetry(((Integer)maxErrorRetryCount.get()).intValue());
        }
        return clientConfiguration;
    }

    public void put(InputStream inputStream, Long contentLength, URI destination) {
        try {
            S3RegionalResource s3RegionalResource = new S3RegionalResource(destination);
            String bucketName = s3RegionalResource.getBucketName();
            String s3BucketKey = s3RegionalResource.getKey();
            this.configureClient(s3RegionalResource);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(contentLength.longValue());
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, s3BucketKey, inputStream, objectMetadata).withCannedAcl(CannedAccessControlList.BucketOwnerFullControl);
            LOGGER.debug("Attempting to put resource:[{}] into s3 bucket [{}]", (Object)s3BucketKey, (Object)bucketName);
            this.amazonS3Client.putObject(putObjectRequest);
        }
        catch (AmazonClientException e) {
            throw ResourceExceptions.putFailed(destination, e);
        }
    }

    public S3Object getMetaData(URI uri) {
        LOGGER.debug("Attempting to get s3 meta-data: [{}]", (Object)uri.toString());
        return this.doGetS3Object(uri, true);
    }

    public S3Object getResource(URI uri) {
        LOGGER.debug("Attempting to get s3 resource: [{}]", (Object)uri.toString());
        return this.doGetS3Object(uri, false);
    }

    public List<String> listDirectChildren(URI parent) {
        S3RegionalResource s3RegionalResource = new S3RegionalResource(parent);
        String bucketName = s3RegionalResource.getBucketName();
        String s3BucketKey = s3RegionalResource.getKey();
        this.configureClient(s3RegionalResource);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(s3BucketKey).withMaxKeys(Integer.valueOf(1000)).withDelimiter("/");
        ObjectListing objectListing = this.amazonS3Client.listObjects(listObjectsRequest);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.resourceResolver.resolveResourceNames(objectListing));
        while (objectListing.isTruncated()) {
            objectListing = this.amazonS3Client.listNextBatchOfObjects(objectListing);
            builder.addAll(this.resourceResolver.resolveResourceNames(objectListing));
        }
        return builder.build();
    }

    private S3Object doGetS3Object(URI uri, boolean isLightWeight) {
        S3RegionalResource s3RegionalResource = new S3RegionalResource(uri);
        String bucketName = s3RegionalResource.getBucketName();
        String s3BucketKey = s3RegionalResource.getKey();
        this.configureClient(s3RegionalResource);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, s3BucketKey);
        if (isLightWeight) {
            getObjectRequest.setRange(0L, 0L);
        }
        try {
            return this.amazonS3Client.getObject(getObjectRequest);
        }
        catch (AmazonServiceException e) {
            String errorCode = e.getErrorCode();
            if (null != errorCode && errorCode.equalsIgnoreCase("NoSuchKey")) {
                return null;
            }
            throw ResourceExceptions.getFailed(uri, e);
        }
    }

    private void configureClient(S3RegionalResource s3RegionalResource) {
        Optional<URI> endpoint = this.s3ConnectionProperties.getEndpoint();
        if (endpoint.isPresent()) {
            this.amazonS3Client.setEndpoint(((URI)endpoint.get()).toString());
        } else {
            Optional<Region> region = s3RegionalResource.getRegion();
            if (region.isPresent()) {
                this.amazonS3Client.setRegion((Region)region.get());
            }
        }
    }
}

