/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpResourceAccessor;
import org.gradle.internal.resource.transport.sftp.SftpResourceLister;
import org.gradle.internal.resource.transport.sftp.SftpResourceUploader;

public class SftpConnectorFactory
implements ResourceConnectorFactory {
    private final SftpClientFactory sftpClientFactory;

    public SftpConnectorFactory(SftpClientFactory sftpClientFactory) {
        this.sftpClientFactory = sftpClientFactory;
    }

    @Override
    public Set<String> getSupportedProtocols() {
        return Collections.singleton("sftp");
    }

    @Override
    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        HashSet<Class<? extends Authentication>> supported = new HashSet<Class<? extends Authentication>>();
        supported.add(AllSchemesAuthentication.class);
        return supported;
    }

    @Override
    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        PasswordCredentials passwordCredentials = connectionDetails.getCredentials(PasswordCredentials.class);
        SftpResourceAccessor accessor = new SftpResourceAccessor(this.sftpClientFactory, passwordCredentials);
        SftpResourceLister lister = new SftpResourceLister(this.sftpClientFactory, passwordCredentials);
        SftpResourceUploader uploader = new SftpResourceUploader(this.sftpClientFactory, passwordCredentials);
        return new DefaultExternalResourceConnector(accessor, lister, uploader);
    }
}

