/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.watch.registry.impl.CheckIfNonEmptySnapshotVisitor;
import org.gradle.internal.watch.registry.impl.SnapshotWatchedDirectoryFinder;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public class WatchedHierarchies {
    private Set<Path> watchedRoots = new HashSet<Path>();
    private FileHierarchySet watchedHierarchies = DefaultFileHierarchySet.of();

    public boolean contains(Path watchableHierarchy) {
        return this.watchedHierarchies.contains(watchableHierarchy.toString());
    }

    public Set<Path> getWatchedRoots() {
        return this.watchedRoots;
    }

    public void updateWatchedHierarchies(WatchableHierarchies watchableHierarchies, SnapshotHierarchy vfsRoot) {
        this.watchedHierarchies = DefaultFileHierarchySet.of();
        Stream<Path> hierarchiesWithSnapshots = watchableHierarchies.getWatchableHierarchies().stream().flatMap(watchableHierarchy -> {
            if (this.watchedHierarchies.contains(watchableHierarchy.toString())) {
                return Stream.empty();
            }
            CheckIfNonEmptySnapshotVisitor checkIfNonEmptySnapshotVisitor = new CheckIfNonEmptySnapshotVisitor(watchableHierarchies);
            vfsRoot.visitSnapshotRoots(watchableHierarchy.toString(), new FilterAlreadyCoveredSnapshotsVisitor(checkIfNonEmptySnapshotVisitor, this.watchedHierarchies));
            if (checkIfNonEmptySnapshotVisitor.isEmpty()) {
                return Stream.empty();
            }
            this.watchedHierarchies = this.watchedHierarchies.plus(watchableHierarchy.toFile());
            return checkIfNonEmptySnapshotVisitor.containsOnlyMissingFiles() ? Stream.of(this.locationOrFirstExistingAncestor((Path)watchableHierarchy)) : Stream.of(watchableHierarchy);
        });
        this.watchedRoots = WatchedHierarchies.resolveHierarchiesToWatch(hierarchiesWithSnapshots);
    }

    private Path locationOrFirstExistingAncestor(Path watchableHierarchy) {
        if (Files.isDirectory(watchableHierarchy, new LinkOption[0])) {
            return watchableHierarchy;
        }
        return SnapshotWatchedDirectoryFinder.findFirstExistingAncestor(watchableHierarchy);
    }

    @VisibleForTesting
    static Set<Path> resolveHierarchiesToWatch(Stream<Path> directories) {
        HashSet<Path> hierarchies = new HashSet<Path>();
        directories.sorted(Comparator.comparingInt(Path::getNameCount)).filter(path -> {
            Path parent = path;
            while ((parent = parent.getParent()) != null) {
                if (!hierarchies.contains(parent)) continue;
                return false;
            }
            return true;
        }).forEach(hierarchies::add);
        return hierarchies;
    }

    private static class FilterAlreadyCoveredSnapshotsVisitor
    implements SnapshotHierarchy.SnapshotVisitor {
        private final SnapshotHierarchy.SnapshotVisitor delegate;
        private final FileHierarchySet alreadyCoveredSnapshots;

        public FilterAlreadyCoveredSnapshotsVisitor(SnapshotHierarchy.SnapshotVisitor delegate, FileHierarchySet alreadyCoveredSnapshots) {
            this.delegate = delegate;
            this.alreadyCoveredSnapshots = alreadyCoveredSnapshots;
        }

        @Override
        public void visitSnapshotRoot(CompleteFileSystemLocationSnapshot snapshot) {
            if (!this.alreadyCoveredSnapshots.contains(snapshot.getAbsolutePath())) {
                this.delegate.visitSnapshotRoot(snapshot);
            }
        }
    }
}

