/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.play.internal.platform.PlayPlatformInternal;

public class DefaultPlayPlatform
implements PlayPlatformInternal {
    public static final String DEFAULT_PLAY_VERSION = "2.6.15";
    private final String playVersion;
    private final ScalaPlatform scalaPlatform;
    private final JavaPlatform javaPlatform;
    private final String name;

    public DefaultPlayPlatform(String name, String playVersion, ScalaPlatform scalaPlatform, JavaPlatform javaPlatform) {
        this.name = name;
        this.playVersion = playVersion;
        this.scalaPlatform = scalaPlatform;
        this.javaPlatform = javaPlatform;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return "Play Platform (Play " + this.playVersion + ", Scala: " + this.scalaPlatform.getScalaCompatibilityVersion() + ", Java: " + this.javaPlatform.getDisplayName() + ")";
    }

    @Override
    public String getPlayVersion() {
        return this.playVersion;
    }

    @Override
    public ScalaPlatform getScalaPlatform() {
        return this.scalaPlatform;
    }

    @Override
    public JavaPlatform getJavaPlatform() {
        return this.javaPlatform;
    }

    @Override
    public String getDependencyNotation(String playModule) {
        return "com.typesafe.play:" + playModule + "_" + this.scalaPlatform.getScalaCompatibilityVersion() + ":" + this.playVersion;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

