/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.play.internal.javascript.DefaultJavaScriptCompileSpec;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.toolchain.PlayToolChain;

@Incubating
@Deprecated
public class JavaScriptMinify
extends SourceTask {
    private File destinationDir;
    private PlayPlatform playPlatform;
    private BaseForkOptions forkOptions;

    public JavaScriptMinify() {
        this.include("**/*.js");
    }

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public PlayToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setPlayPlatform(PlayPlatform playPlatform) {
        this.playPlatform = playPlatform;
    }

    private Compiler<JavaScriptCompileSpec> getCompiler() {
        PlayToolProvider select = ((PlayToolChainInternal)this.getToolChain()).select(this.playPlatform);
        return select.newCompiler(JavaScriptCompileSpec.class);
    }

    @Nested
    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }

    @TaskAction
    void compileJavaScriptSources() {
        boolean cleanedOutputs = StaleOutputCleaner.cleanOutputs(this.getDeleter(), this.getOutputs().getPreviousOutputFiles(), this.getDestinationDir());
        MinifyFileVisitor visitor = new MinifyFileVisitor();
        this.getSource().visit(visitor);
        DefaultJavaScriptCompileSpec spec = new DefaultJavaScriptCompileSpec(visitor.relativeFiles, this.getDestinationDir(), this.getForkOptions());
        WorkResult result = this.getCompiler().execute(spec);
        this.setDidWork(result.getDidWork() || cleanedOutputs);
    }

    class MinifyFileVisitor
    implements FileVisitor {
        List<RelativeFile> relativeFiles = Lists.newArrayList();

        MinifyFileVisitor() {
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            new File(JavaScriptMinify.this.destinationDir, dirDetails.getRelativePath().getPathString()).mkdirs();
        }

        @Override
        public void visitFile(final FileVisitDetails fileDetails) {
            final File outputFileDir = new File(JavaScriptMinify.this.destinationDir, fileDetails.getRelativePath().getParent().getPathString());
            JavaScriptMinify.this.getFileSystemOperations().copy((Action<? super CopySpec>)new Action<CopySpec>(){

                @Override
                public void execute(CopySpec copySpec) {
                    copySpec.from(fileDetails.getFile()).into(outputFileDir);
                }
            });
            this.relativeFiles.add(new RelativeFile(fileDetails.getFile(), fileDetails.getRelativePath()));
        }
    }
}

