/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import org.gradle.api.Action;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExecutionWorker
implements Action<WorkerProcessContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<? super WorkerProcessContext> action;

    public ActionExecutionWorker(Action<? super WorkerProcessContext> action) {
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(WorkerProcessContext workerContext) {
        LOGGER.debug("Starting {}.", (Object)workerContext.getDisplayName());
        ObjectConnection clientConnection = workerContext.getServerConnection();
        clientConnection.addUnrecoverableErrorHandler(new Action<Throwable>(){

            @Override
            public void execute(Throwable throwable) {
                if (ActionExecutionWorker.this.action instanceof Stoppable) {
                    ((Stoppable)((Object)ActionExecutionWorker.this.action)).stop();
                }
            }
        });
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
        try {
            this.action.execute(workerContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        LOGGER.debug("Completed {}.", (Object)workerContext.getDisplayName());
    }
}

