/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.connection;

import java.util.Collections;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

public class BuildLogLevelMixIn {
    private final ProviderOperationParameters parameters;

    public BuildLogLevelMixIn(ProviderOperationParameters parameters) {
        this.parameters = parameters;
    }

    public LogLevel getBuildLogLevel() {
        LoggingConfigurationBuildOptions loggingBuildOptions = new LoggingConfigurationBuildOptions();
        CommandLineConverter<DefaultLoggingConfiguration> converter = loggingBuildOptions.commandLineConverter();
        CommandLineParser parser = new CommandLineParser().allowUnknownOptions().allowMixedSubcommandsAndOptions();
        converter.configure(parser);
        List<String> arguments = this.parameters.getArguments();
        ParsedCommandLine parsedCommandLine = parser.parse(arguments == null ? Collections.emptyList() : arguments);
        if (this.parameters.getVerboseLogging() && !parsedCommandLine.hasAnyOption(loggingBuildOptions.getLogLevelOptions())) {
            return LogLevel.DEBUG;
        }
        LoggingConfiguration loggingConfiguration = converter.convert(parsedCommandLine, new DefaultLoggingConfiguration());
        return loggingConfiguration.getLogLevel();
    }
}

