/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class PackageAnnotator {
    private static final Logger LOG = Logger.getInstance(PackageAnnotator.class);
    @NonNls
    private static final String DEFAULT_CONSTRUCTOR_NAME_SIGNATURE = "<init>()V";
    private final PsiPackage myPackage;
    private final Project myProject;
    private final CoverageDataManager myCoverageManager;
    private final boolean myIgnoreEmptyPrivateConstructors;
    private final boolean myIgnoreImplicitConstructor;

    public PackageAnnotator(PsiPackage aPackage) {
        this.myPackage = aPackage;
        this.myProject = this.myPackage.getProject();
        this.myCoverageManager = CoverageDataManager.getInstance((Project)this.myProject);
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(this.myProject);
        this.myIgnoreEmptyPrivateConstructors = optionsProvider.ignoreEmptyPrivateConstructors();
        this.myIgnoreImplicitConstructor = optionsProvider.ignoreImplicitConstructors();
    }

    public void annotate(CoverageSuitesBundle suite, Annotator annotator) {
        PackageCoverageInfo info;
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        String qualifiedName = this.myPackage.getQualifiedName();
        boolean filtered = false;
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            if (!(coverageSuite instanceof JavaCoverageSuite) || !((JavaCoverageSuite)coverageSuite).isPackageFiltered(qualifiedName)) continue;
            filtered = true;
            break;
        }
        if (!filtered) {
            return;
        }
        GlobalSearchScope scope = suite.getSearchScope(this.myProject);
        Module[] modules = (Module[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        if (modules == null) {
            return;
        }
        HashMap<String, PackageCoverageInfo> packageCoverageMap = new HashMap<String, PackageCoverageInfo>();
        HashMap<String, PackageCoverageInfo> flattenPackageCoverageMap = new HashMap<String, PackageCoverageInfo>();
        for (Module module : modules) {
            VirtualFile[] allRoots;
            if (!scope.isSearchInModuleContent(module)) continue;
            String rootPackageVMName = qualifiedName.replaceAll("\\.", "/");
            VirtualFile[] productionRoots = (VirtualFile[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules().productionOnly().classes().getRoots());
            HashSet<VirtualFile> productionRootsSet = new HashSet<VirtualFile>();
            if (productionRoots != null) {
                HashMap<VirtualFile, DirCoverageInfo> dirsMap = new HashMap<VirtualFile, DirCoverageInfo>();
                RootWalker rootWalker = new RootWalker(packageCoverageMap, dirsMap, flattenPackageCoverageMap, annotator, data, suite, GlobalSearchScope.moduleScope((Module)module));
                for (VirtualFile output : productionRoots) {
                    productionRootsSet.add(output);
                    File outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, output);
                    if (outputRoot.exists()) {
                        rootWalker.collectCoverageDataInRoot(outputRoot, rootPackageVMName, PackageAnnotator.prepareRoots(module, rootPackageVMName, false));
                    }
                    for (DirCoverageInfo dir : dirsMap.values()) {
                        annotator.annotateSourceDirectory(dir.sourceRoot, dir, module);
                    }
                }
            }
            if (!suite.isTrackTestFolders() || (allRoots = (VirtualFile[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules().classes().getRoots())) == null) continue;
            HashMap<VirtualFile, DirCoverageInfo> dirsMap = new HashMap<VirtualFile, DirCoverageInfo>();
            RootWalker rootWalker = new RootWalker(packageCoverageMap, dirsMap, flattenPackageCoverageMap, annotator, data, suite, GlobalSearchScope.moduleScope((Module)module));
            for (VirtualFile root : allRoots) {
                File outputRoot;
                if (productionRootsSet.contains(root) || !(outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, root)).exists()) continue;
                rootWalker.collectCoverageDataInRoot(outputRoot, rootPackageVMName, PackageAnnotator.prepareRoots(module, rootPackageVMName, true));
            }
            for (DirCoverageInfo dir : dirsMap.values()) {
                annotator.annotateTestDirectory(dir.sourceRoot, dir, module);
            }
        }
        for (Map.Entry entry : packageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info);
        }
        for (Map.Entry entry : flattenPackageCoverageMap.entrySet()) {
            String packageFQName = ((String)entry.getKey()).replaceAll("/", ".");
            info = (PackageCoverageInfo)entry.getValue();
            annotator.annotatePackage(packageFQName, info, true);
        }
    }

    private static VirtualFile[] prepareRoots(Module module, String rootPackageVMName, boolean isTestHierarchy) {
        ContentEntry[] contentEntries;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders((JpsModuleSourceRootType)(isTestHierarchy ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE))) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                String prefix = folder.getPackagePrefix().replaceAll("\\.", "/");
                VirtualFile relativeSrcRoot = file.findFileByRelativePath(StringUtil.trimStart((String)rootPackageVMName, (String)prefix));
                result.add(relativeSrcRoot);
            }
        }
        return result.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @NotNull
    private static File findRelativeFile(@NotNull String rootPackageVMName, VirtualFile output) {
        if (rootPackageVMName == null) {
            PackageAnnotator.$$$reportNull$$$0(0);
        }
        File outputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)output);
        File file = outputRoot = rootPackageVMName.length() > 0 ? new File(outputRoot, FileUtil.toSystemDependentName((String)rootPackageVMName)) : outputRoot;
        if (file == null) {
            PackageAnnotator.$$$reportNull$$$0(1);
        }
        return file;
    }

    public void annotateFilteredClass(PsiClass psiClass, @NotNull CoverageSuitesBundle bundle, Annotator annotator) {
        ProjectData data;
        if (bundle == null) {
            PackageAnnotator.$$$reportNull$$$0(2);
        }
        if ((data = bundle.getCoverageData()) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            VirtualFile outputPath;
            boolean isInTests = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().isInTestSourceContent(psiClass.getContainingFile().getVirtualFile());
            CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile virtualFile = outputPath = isInTests ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
            if (outputPath != null) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return;
                }
                String packageVMName = StringUtil.getPackageName((String)qualifiedName).replace('.', '/');
                File packageRoot = PackageAnnotator.findRelativeFile(packageVMName, outputPath);
                if (packageRoot.exists()) {
                    HashMap<String, ClassCoverageInfo> toplevelClassCoverage = new HashMap<String, ClassCoverageInfo>();
                    File[] files = packageRoot.listFiles();
                    if (files != null) {
                        for (File child : files) {
                            if (!PackageAnnotator.isClassFile(child)) continue;
                            String childName = PackageAnnotator.getClassName(child);
                            Object classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                            String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName((String)classFqVMName);
                            if (!toplevelClassSrcFQName.equals(qualifiedName)) continue;
                            this.collectClassCoverageInformation(child, psiClass, new PackageCoverageInfo(), data, toplevelClassCoverage, ((String)classFqVMName).replace("/", "."), toplevelClassSrcFQName);
                        }
                    }
                    for (ClassCoverageInfo coverageInfo : toplevelClassCoverage.values()) {
                        annotator.annotateClass(qualifiedName, coverageInfo);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void collectClassCoverageInformation(File classFile, @Nullable PsiClass psiClass, PackageCoverageInfo packageCoverageInfo, ProjectData projectInfo, Map<String, ClassCoverageInfo> toplevelClassCoverage, String className, String toplevelClassSrcFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = new ClassCoverageInfo();
        ClassData classData = projectInfo.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            if (!this.collectNonCoveredClassInfo(classFile, psiClass, toplevelClassCoverageInfo, packageCoverageInfo)) {
                LOG.debug("Did not collect non-covered class info for " + classFile.getName());
                return;
            }
        } else {
            Object[] lines;
            for (Object l : lines = classData.getLines()) {
                if (!(l instanceof LineData)) continue;
                LineData lineData = (LineData)l;
                if (lineData.getStatus() == 2) {
                    ++toplevelClassCoverageInfo.fullyCoveredLineCount;
                } else if (lineData.getStatus() == 1) {
                    ++toplevelClassCoverageInfo.partiallyCoveredLineCount;
                } else if ((this.myIgnoreEmptyPrivateConstructors || this.myIgnoreImplicitConstructor) && PackageAnnotator.isGeneratedDefaultConstructor(psiClass, lineData.getMethodSignature(), this.myIgnoreImplicitConstructor, this.myIgnoreEmptyPrivateConstructors)) continue;
                ++toplevelClassCoverageInfo.totalLineCount;
                ++packageCoverageInfo.totalLineCount;
                BranchData branchData = lineData.getBranchData();
                if (branchData == null) continue;
                toplevelClassCoverageInfo.totalBranchCount += branchData.getTotalBranches();
                toplevelClassCoverageInfo.coveredBranchCount += branchData.getCoveredBranches();
            }
            boolean touchedClass = false;
            Collection methodSigs = classData.getMethodSigs();
            for (Object nameAndSig : methodSigs) {
                int covered = classData.getStatus((String)nameAndSig);
                if (covered != 0) {
                    touchedClass = true;
                }
                if ((this.myIgnoreEmptyPrivateConstructors || this.myIgnoreImplicitConstructor) && PackageAnnotator.isGeneratedDefaultConstructor(psiClass, (String)nameAndSig, this.myIgnoreImplicitConstructor, this.myIgnoreEmptyPrivateConstructors)) continue;
                if (covered != 0) {
                    ++toplevelClassCoverageInfo.coveredMethodCount;
                }
                ++toplevelClassCoverageInfo.totalMethodCount;
            }
            if (methodSigs.isEmpty()) {
                LOG.debug("Did not find any method signatures in " + classFile.getName());
                return;
            }
            if (touchedClass) {
                ++packageCoverageInfo.coveredClassCount;
            }
            ++packageCoverageInfo.totalClassCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
            packageCoverageInfo.coveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
            packageCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
            packageCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
            packageCoverageInfo.coveredBranchCount += toplevelClassCoverageInfo.coveredBranchCount;
            packageCoverageInfo.totalBranchCount += toplevelClassCoverageInfo.totalBranchCount;
        }
        ClassCoverageInfo classCoverageInfo = PackageAnnotator.getOrCreateClassCoverageInfo(toplevelClassCoverage, toplevelClassSrcFQName);
        LOG.debug("Adding coverage of " + classFile.getName() + " to top-level class " + toplevelClassSrcFQName);
        classCoverageInfo.totalLineCount += toplevelClassCoverageInfo.totalLineCount;
        classCoverageInfo.fullyCoveredLineCount += toplevelClassCoverageInfo.fullyCoveredLineCount;
        classCoverageInfo.partiallyCoveredLineCount += toplevelClassCoverageInfo.partiallyCoveredLineCount;
        classCoverageInfo.totalMethodCount += toplevelClassCoverageInfo.totalMethodCount;
        classCoverageInfo.coveredMethodCount += toplevelClassCoverageInfo.coveredMethodCount;
        classCoverageInfo.totalBranchCount += toplevelClassCoverageInfo.totalBranchCount;
        classCoverageInfo.coveredBranchCount += toplevelClassCoverageInfo.coveredBranchCount;
        if (toplevelClassCoverageInfo.getCoveredLineCount() > 0) {
            ++classCoverageInfo.coveredClassCount;
        }
    }

    private static boolean isClassFile(File classFile) {
        return classFile.getName().endsWith(".class");
    }

    private static String getClassName(File classFile) {
        return StringUtil.trimEnd((String)classFile.getName(), (String)".class");
    }

    public static boolean isGeneratedDefaultConstructor(@Nullable PsiClass aClass, String nameAndSig, boolean implicitConstructor, boolean privateEmpty) {
        if (aClass == null || !implicitConstructor && !privateEmpty) {
            return false;
        }
        if (DEFAULT_CONSTRUCTOR_NAME_SIGNATURE.equals(nameAndSig)) {
            return PackageAnnotator.hasGeneratedOrEmptyPrivateConstructor(aClass, implicitConstructor, privateEmpty);
        }
        return false;
    }

    private static boolean hasGeneratedOrEmptyPrivateConstructor(@NotNull PsiClass aClass, boolean implicitConstructor, boolean privateEmpty) {
        if (aClass == null) {
            PackageAnnotator.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            PsiMethod[] constructors = aClass.getConstructors();
            if (privateEmpty && constructors.length == 1 && constructors[0].hasModifierProperty("private")) {
                PsiCodeBlock body = constructors[0].getBody();
                return body != null && body.isEmpty() && ContainerUtil.and((Object[])aClass.getMethods(), method -> method.isConstructor() || method.hasModifierProperty("static"));
            }
            return implicitConstructor && constructors.length == 0;
        });
    }

    private static ClassCoverageInfo getOrCreateClassCoverageInfo(Map<String, ClassCoverageInfo> toplevelClassCoverage, String sourceToplevelFQName) {
        ClassCoverageInfo toplevelClassCoverageInfo = toplevelClassCoverage.get(sourceToplevelFQName);
        if (toplevelClassCoverageInfo == null) {
            toplevelClassCoverageInfo = new ClassCoverageInfo();
            toplevelClassCoverage.put(sourceToplevelFQName, toplevelClassCoverageInfo);
        } else {
            ++toplevelClassCoverageInfo.totalClassCount;
        }
        return toplevelClassCoverageInfo;
    }

    private static String getSourceToplevelFQName(String classFQVMName) {
        int index = classFQVMName.indexOf(36);
        if (index > 0) {
            classFQVMName = classFQVMName.substring(0, index);
        }
        classFQVMName = StringUtil.trimStart((String)classFQVMName, (String)"/");
        return classFQVMName.replaceAll("/", ".");
    }

    private boolean collectNonCoveredClassInfo(File classFile, @Nullable PsiClass psiClass, ClassCoverageInfo classCoverageInfo, PackageCoverageInfo packageCoverageInfo) {
        byte[] content = (byte[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> {
            try {
                return FileUtil.loadFileBytes((File)classFile);
            }
            catch (IOException e) {
                return null;
            }
        });
        CoverageSuitesBundle coverageSuite = CoverageDataManager.getInstance((Project)this.myProject).getCurrentSuitesBundle();
        if (coverageSuite == null) {
            return false;
        }
        return SourceLineCounterUtil.collectNonCoveredClassInfo(classCoverageInfo, packageCoverageInfo, content, coverageSuite.isTracingEnabled(), (Condition<? super String>)(this.myIgnoreEmptyPrivateConstructors || this.myIgnoreImplicitConstructor ? description -> !PackageAnnotator.isGeneratedDefaultConstructor(psiClass, description, this.myIgnoreImplicitConstructor, this.myIgnoreEmptyPrivateConstructors) : Conditions.alwaysTrue()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPackageVMName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/PackageAnnotator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/PackageAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelativeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotateFilteredClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasGeneratedOrEmptyPrivateConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class RootWalker {
        private final Map<String, PackageCoverageInfo> packageCoverageMap;
        private final Map<VirtualFile, DirCoverageInfo> dirsCoverageMap;
        private final Map<String, PackageCoverageInfo> flattenPackageCoverageMap;
        private final Annotator annotator;
        private final ProjectData projectInfo;
        private final CoverageSuitesBundle bundle;
        private final GlobalSearchScope globalSearchScope;

        private RootWalker(Map<String, PackageCoverageInfo> packageCoverageMap, Map<VirtualFile, DirCoverageInfo> dirsCoverageMap, Map<String, PackageCoverageInfo> flattenPackageCoverageMap, Annotator annotator, ProjectData projectInfo, CoverageSuitesBundle bundle, GlobalSearchScope globalSearchScope) {
            this.packageCoverageMap = packageCoverageMap;
            this.dirsCoverageMap = dirsCoverageMap;
            this.flattenPackageCoverageMap = flattenPackageCoverageMap;
            this.annotator = annotator;
            this.projectInfo = projectInfo;
            this.bundle = bundle;
            this.globalSearchScope = globalSearchScope;
        }

        private void collectCoverageDataInRoot(File packageOutputRoot, String packageVMName, VirtualFile[] sourceRoots) {
            File[] children = packageOutputRoot.listFiles();
            if (children == null) {
                return;
            }
            PackageCoverageInfo classWithoutSourceCoverageInfo = new PackageCoverageInfo();
            HashMap<String, ClassCoverageInfo> toplevelClassCoverage = new HashMap<String, ClassCoverageInfo>();
            for (File child : children) {
                PackageCoverageInfo coverageInfoForClass;
                String childName;
                if (child.isDirectory()) {
                    childName = child.getName();
                    String childPackageVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                    VirtualFile[] childSourceRoots = (VirtualFile[])Arrays.stream(sourceRoots).map(root -> root != null ? root.findFileByRelativePath(childName) : null).toArray(VirtualFile[]::new);
                    this.collectCoverageDataInRoot(child, childPackageVMName, childSourceRoots);
                    for (int i = 0; i < sourceRoots.length; ++i) {
                        PackageCoverageInfo coverageInfo;
                        VirtualFile childRoot = childSourceRoots[i];
                        PackageCoverageInfo packageCoverageInfo = coverageInfo = childRoot != null ? (PackageCoverageInfo)this.dirsCoverageMap.get(childRoot) : null;
                        if (coverageInfo == null) continue;
                        this.dirsCoverageMap.computeIfAbsent(sourceRoots[i], srcRoot -> new DirCoverageInfo((VirtualFile)srcRoot)).append(coverageInfo);
                    }
                    continue;
                }
                if (!PackageAnnotator.isClassFile(child)) continue;
                childName = PackageAnnotator.getClassName(child);
                Object classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName((String)classFqVMName);
                if (this.ignoreClass(this.bundle, child, toplevelClassSrcFQName)) continue;
                Ref containingFileRef = new Ref();
                Ref psiClassRef = new Ref();
                Boolean isInSource = (Boolean)DumbService.getInstance((Project)PackageAnnotator.this.myProject).runReadActionInSmartMode(() -> {
                    if (PackageAnnotator.this.myProject.isDisposed()) {
                        return null;
                    }
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)PackageAnnotator.this.myProject).findClass(toplevelClassSrcFQName, this.globalSearchScope);
                    if (aClass == null || !aClass.isValid()) {
                        return Boolean.FALSE;
                    }
                    psiClassRef.set((Object)aClass);
                    PsiElement element = aClass.getNavigationElement();
                    containingFileRef.set((Object)PsiUtilCore.getVirtualFile((PsiElement)element));
                    if (containingFileRef.isNull()) {
                        LOG.info("No virtual file found for: " + aClass);
                        return null;
                    }
                    return this.bundle.getCoverageEngine().acceptedByFilters(element.getContainingFile(), this.bundle);
                });
                if (isInSource == null || !isInSource.booleanValue()) continue;
                VirtualFile virtualFile = (VirtualFile)containingFileRef.get();
                if (virtualFile != null) {
                    coverageInfoForClass = this.dirsCoverageMap.computeIfAbsent(virtualFile.getParent(), DirCoverageInfo::new);
                } else {
                    if (!ContainerUtil.exists((Object[])((JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()), extension -> extension.keepCoverageInfoForClassWithoutSource(this.bundle, child))) continue;
                    coverageInfoForClass = classWithoutSourceCoverageInfo;
                }
                PackageAnnotator.this.collectClassCoverageInformation(child, (PsiClass)psiClassRef.get(), coverageInfoForClass, this.projectInfo, toplevelClassCoverage, ((String)classFqVMName).replace("/", "."), toplevelClassSrcFQName);
            }
            PackageCoverageInfo flattenPackageCoverageInfo = this.flattenPackageCoverageMap.computeIfAbsent(packageVMName, k -> new PackageCoverageInfo());
            for (Map.Entry entry : toplevelClassCoverage.entrySet()) {
                ClassCoverageInfo coverageInfo = (ClassCoverageInfo)entry.getValue();
                flattenPackageCoverageInfo.append(coverageInfo);
                this.annotator.annotateClass((String)entry.getKey(), coverageInfo);
            }
            PackageCoverageInfo packageCoverageInfo = this.packageCoverageMap.computeIfAbsent(packageVMName, k -> new PackageCoverageInfo());
            Arrays.stream(sourceRoots).map(this.dirsCoverageMap::get).filter(Objects::nonNull).forEach(packageCoverageInfo::append);
            packageCoverageInfo.append(classWithoutSourceCoverageInfo);
        }

        private boolean ignoreClass(CoverageSuitesBundle bundle, File child, String toplevelClassSrcFQName) {
            for (JavaCoverageEngineExtension javaCoverageEngineExtension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
                if (!javaCoverageEngineExtension.ignoreCoverageForClass(bundle, child)) continue;
                return true;
            }
            for (JavaCoverageEngineExtension javaCoverageEngineExtension : bundle.getSuites()) {
                if (!(javaCoverageEngineExtension instanceof JavaCoverageSuite) || !((JavaCoverageSuite)((Object)javaCoverageEngineExtension)).isClassFiltered(toplevelClassSrcFQName, ((JavaCoverageSuite)((Object)javaCoverageEngineExtension)).getExcludedClassNames())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DirCoverageInfo
    extends PackageCoverageInfo {
        public VirtualFile sourceRoot;

        public DirCoverageInfo(VirtualFile sourceRoot) {
            this.sourceRoot = sourceRoot;
        }
    }

    public static class PackageCoverageInfo
    extends SummaryCoverageInfo {
        public int coveredLineCount;

        @Override
        public int getCoveredLineCount() {
            return this.coveredLineCount;
        }

        public void append(SummaryCoverageInfo info) {
            this.totalClassCount += info.totalClassCount;
            this.totalLineCount += info.totalLineCount;
            this.coveredClassCount += info.coveredClassCount;
            this.coveredLineCount += info.getCoveredLineCount();
            this.coveredMethodCount += info.coveredMethodCount;
            this.totalMethodCount += info.totalMethodCount;
            this.totalBranchCount += info.totalBranchCount;
            this.coveredBranchCount += info.coveredBranchCount;
        }
    }

    public static class ClassCoverageInfo
    extends SummaryCoverageInfo {
        public int fullyCoveredLineCount;
        public int partiallyCoveredLineCount;

        public ClassCoverageInfo() {
            this.totalClassCount = 1;
        }

        @Override
        public int getCoveredLineCount() {
            return this.fullyCoveredLineCount + this.partiallyCoveredLineCount;
        }
    }

    public static abstract class SummaryCoverageInfo {
        public int totalClassCount;
        public int coveredClassCount;
        public int totalMethodCount;
        public int coveredMethodCount;
        public int totalLineCount;
        public int coveredBranchCount;
        public int totalBranchCount;

        public abstract int getCoveredLineCount();
    }

    public static interface Annotator {
        default public void annotateSourceDirectory(VirtualFile virtualFile, PackageCoverageInfo packageCoverageInfo, Module module) {
        }

        default public void annotateTestDirectory(VirtualFile virtualFile, PackageCoverageInfo packageCoverageInfo, Module module) {
        }

        default public void annotatePackage(String packageQualifiedName, PackageCoverageInfo packageCoverageInfo) {
        }

        default public void annotatePackage(String packageQualifiedName, PackageCoverageInfo packageCoverageInfo, boolean flatten) {
        }

        default public void annotateClass(String classQualifiedName, ClassCoverageInfo classCoverageInfo) {
        }
    }
}

