/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.FileUtils;
import com.intellij.xml.actions.xmlbeans.GenerateInstanceDocumentFromSchemaDialog;
import com.intellij.xml.actions.xmlbeans.Xsd2InstanceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GenerateInstanceDocumentFromSchemaAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(0);
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = GenerateInstanceDocumentFromSchemaAction.isAcceptableFile(file);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GenerateInstanceDocumentFromSchemaDialog dialog = new GenerateInstanceDocumentFromSchemaDialog(project, file);
        dialog.setOkAction(() -> GenerateInstanceDocumentFromSchemaAction.doAction(project, dialog));
        dialog.show();
    }

    public static void doAction(Project project, GenerateInstanceDocumentFromSchemaDialog dialog) {
        String xml;
        String pathToUse;
        FileDocumentManager.getInstance().saveAllDocuments();
        @NonNls LinkedList<Object> parameters = new LinkedList<Object>();
        String url = dialog.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(relativeFile);
        if (!(file instanceof XmlFile)) {
            Messages.showErrorDialog((Project)project, (String)(" (" + file.getFileType().getDescription() + ")"), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        if (!dialog.enableRestrictionCheck()) {
            parameters.add("-nopvr");
        }
        if (!dialog.enableUniquenessCheck()) {
            parameters.add("-noupa");
        }
        parameters.add("-dl");
        try {
            final File tempDir = FileUtil.createTempFile((String)"xsd2inst", (String)"");
            tempDir.delete();
            tempDir.mkdir();
            pathToUse = tempDir.getPath() + File.separatorChar + Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)file, new HashMap<String, String>(), new Xsd2InstanceUtils.SchemaReferenceProcessor(){

                @Override
                public void processSchema(String schemaFileName, byte[] schemaContent) {
                    try {
                        String fullFileName = tempDir.getPath() + File.separatorChar + schemaFileName;
                        FileUtils.saveStreamContentAsFile(fullFileName, new ByteArrayInputStream(schemaContent));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return;
        }
        parameters.add(pathToUse);
        parameters.add("-name");
        parameters.add(dialog.getElementName());
        try {
            xml = Xsd2InstanceUtils.generate(ArrayUtilRt.toStringArray(parameters));
        }
        catch (IllegalArgumentException e) {
            Messages.showErrorDialog((Project)project, (String)StringUtil.getMessage((Throwable)e), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        String xmlFileName = relativeFileDir.getPath() + File.separatorChar + dialog.getOutputFileName();
        try {
            File xmlFile = new File(xmlFileName);
            FileUtil.writeToFile((File)xmlFile, (String)xml);
            VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xmlFile));
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"could.not.save.generated.xml.document.0", (Object[])new Object[]{StringUtil.getMessage((Throwable)e)}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
    }

    static boolean isAcceptableFileForGenerateSchemaFromInstanceDocument(VirtualFile virtualFile) {
        return virtualFile != null && "xsd".equalsIgnoreCase(virtualFile.getExtension());
    }

    public static boolean isAcceptableFile(VirtualFile file) {
        return GenerateInstanceDocumentFromSchemaAction.isAcceptableFileForGenerateSchemaFromInstanceDocument(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/xml/actions/xmlbeans/GenerateInstanceDocumentFromSchemaAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

