/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.TargetElementUtilExtender;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.BitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;

    public static TargetElementUtil getInstance() {
        return (TargetElementUtil)ApplicationManager.getApplication().getService(TargetElementUtil.class);
    }

    public int getAllAccepted() {
        int result2 = 11;
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAllAdditionalFlags();
        }
        return result2;
    }

    public int getDefinitionSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalDefinitionSearchFlags();
        }
        return result2;
    }

    public int getReferenceSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : TargetElementUtilExtender.EP_NAME.getExtensionList()) {
            result2 |= each.getAdditionalReferenceSearchFlags();
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor) {
        int offset;
        PsiReference result2;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(0);
        }
        if ((result2 = TargetElementUtil.findReference(editor, offset = editor.getCaretModel().getOffset())) == null) {
            int expectedCaretOffset;
            int n = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
            if (expectedCaretOffset != offset) {
                result2 = TargetElementUtil.findReference(editor, expectedCaretOffset);
            }
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(1);
        }
        return TargetElementUtilBase.findReference(editor, offset);
    }

    public static int adjustOffset(@Nullable PsiFile file2, Document document, int offset) {
        return TargetElementUtilBase.adjustOffset(file2, document, offset);
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(2);
        }
        return offset == editor.getCaretModel().getOffset() && EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor, int flags) {
        int expectedCaretOffset;
        int offset = editor.getCaretModel().getOffset();
        PsiElement result2 = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset);
        if (result2 != null) {
            return result2;
        }
        int n = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
        if (expectedCaretOffset != offset) {
            return TargetElementUtil.getInstance().findTargetElement(editor, flags, expectedCaretOffset);
        }
        return null;
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement element2;
        Project project;
        if (editor == null) {
            TargetElementUtil.$$$reportNull$$$0(3);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)8) && (element2 = TargetElementUtil.getTargetElementFromLookup(project)) != null) {
            return element2;
        }
        return TargetElementUtilBase.findTargetElement(editor, flags, offset);
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getTargetElementFromLookup(Project project) {
        PsiElement psi;
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null && item.isValid() && (psi = CompletionUtil.getTargetElement(item)) != null && psi.isValid()) {
            return psi;
        }
        return null;
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, @Nullable PsiElement element2, @Nullable PsiElement contextElement) {
        TargetElementEvaluatorEx2 evaluator;
        PsiElement langElement = element2 == null ? contextElement : element2;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = langElement != null ? TargetElementUtilBase.getElementEvaluatorsEx2(langElement.getLanguage()) : null;
        if (evaluator != null) {
            element2 = evaluator.adjustElement(editor, flags, element2, contextElement);
        }
        return element2;
    }

    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        PsiElement element2;
        TargetElementEvaluatorEx2 evaluator;
        if (ref == null) {
            TargetElementUtil.$$$reportNull$$$0(4);
        }
        return (evaluator = TargetElementUtilBase.getElementEvaluatorsEx2((element2 = ref.getElement()).getLanguage())) != null ? evaluator.adjustReference(ref) : null;
    }

    @Nullable
    public PsiElement getNamedElement(@Nullable PsiElement element2, int offsetInElement) {
        return TargetElementUtilBase.getNamedElement(element2, offsetInElement);
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getNamedElement(@Nullable PsiElement element2) {
        return TargetElementUtilBase.getNamedElement(element2);
    }

    @NotNull
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference2) {
        Collection<PsiElement> candidates;
        PsiElement refElement;
        TargetElementEvaluatorEx2 evaluator;
        if (reference2 == null) {
            TargetElementUtil.$$$reportNull$$$0(5);
        }
        if ((evaluator = TargetElementUtilBase.getElementEvaluatorsEx2((refElement = reference2.getElement()).getLanguage())) != null && (candidates = evaluator.getTargetCandidates(reference2)) != null) {
            Collection<PsiElement> collection = candidates;
            if (collection == null) {
                TargetElementUtil.$$$reportNull$$$0(6);
            }
            return collection;
        }
        if (reference2 instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference2).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r : results) {
                PsiElement element2 = r.getElement();
                if (!this.isNavigatableSource(element2)) continue;
                navigatableResults.add(element2);
            }
            ArrayList<PsiElement> arrayList = navigatableResults;
            if (arrayList == null) {
                TargetElementUtil.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        PsiElement resolved = reference2.resolve();
        if (resolved instanceof NavigationItem) {
            Set<PsiElement> set2 = Collections.singleton(resolved);
            if (set2 == null) {
                TargetElementUtil.$$$reportNull$$$0(8);
            }
            return set2;
        }
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            TargetElementUtil.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Contract(value="null -> false")
    public boolean isNavigatableSource(@Nullable PsiElement element2) {
        return EditSourceUtil.canNavigate((PsiElement)element2) || element2 instanceof Navigatable && ((Navigatable)element2).canNavigateToSource();
    }

    public PsiElement getGotoDeclarationTarget(PsiElement element2, PsiElement navElement) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element2 != null ? TargetElementUtilBase.getElementEvaluatorsEx2(element2.getLanguage()) : null;
        if (evaluator != null && (result2 = evaluator.getGotoDeclarationTarget(element2, navElement)) != null) {
            return result2;
        }
        return navElement;
    }

    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element2) {
        TargetElementEvaluator evaluator;
        if (element2 == null) {
            TargetElementUtil.$$$reportNull$$$0(10);
        }
        return (evaluator = (TargetElementEvaluator)TargetElementUtilBase.TARGET_ELEMENT_EVALUATOR.forLanguage(element2.getLanguage())) == null || evaluator.includeSelfInGotoImplementation(element2);
    }

    public boolean acceptImplementationForReference(@Nullable PsiReference reference2, @Nullable PsiElement element2) {
        TargetElementEvaluatorEx2 evaluator = element2 != null ? TargetElementUtilBase.getElementEvaluatorsEx2((Language)ReadAction.compute(() -> ((PsiElement)element2).getLanguage())) : null;
        return evaluator == null || evaluator.acceptImplementationForReference(reference2, element2);
    }

    @NotNull
    public SearchScope getSearchScope(Editor editor, @NotNull PsiElement element2) {
        TargetElementEvaluatorEx2 evaluator;
        SearchScope result2;
        if (element2 == null) {
            TargetElementUtil.$$$reportNull$$$0(11);
        }
        SearchScope searchScope2 = result2 = (evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(element2.getLanguage())) != null ? evaluator.getSearchScope(editor, element2) : null;
        if (result2 != null) {
            SearchScope searchScope3 = result2;
            if (searchScope3 == null) {
                TargetElementUtil.$$$reportNull$$$0(12);
            }
            return searchScope3;
        }
        PsiFile file2 = element2.getContainingFile();
        SearchScope searchScope4 = PsiSearchHelper.getInstance((Project)element2.getProject()).getUseScope((PsiElement)(file2 != null ? file2 : element2));
        if (searchScope4 == null) {
            TargetElementUtil.$$$reportNull$$$0(13);
        }
        return searchScope4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TargetElementUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetCandidates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inVirtualSpace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCandidates";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeSelfInGotoImplementation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

