/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionThreading;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Objects;

public abstract class CompletionThreadingBase
implements CompletionThreading {
    protected static final ThreadLocal<Boolean> ourIsInBatchUpdate = ThreadLocal.withInitial(() -> Boolean.FALSE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withBatchUpdate(Runnable runnable2, CompletionProcess process2) {
        if (ourIsInBatchUpdate.get().booleanValue() || !(process2 instanceof CompletionProgressIndicator)) {
            runnable2.run();
            return;
        }
        try {
            ourIsInBatchUpdate.set(Boolean.TRUE);
            runnable2.run();
            ProgressManager.checkCanceled();
            CompletionProgressIndicator currentIndicator = (CompletionProgressIndicator)process2;
            CompletionThreadingBase threading = Objects.requireNonNull(currentIndicator.getCompletionThreading());
            threading.flushBatchResult(currentIndicator);
        }
        finally {
            ourIsInBatchUpdate.set(Boolean.FALSE);
        }
    }

    protected abstract void flushBatchResult(CompletionProgressIndicator var1);
}

