/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnSelectWordHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public UnSelectWordHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project;
        if (editor == null) {
            UnSelectWordHandler.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        UnSelectWordHandler.doAction(editor, file2);
    }

    private static void doAction(final @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement anotherElement;
        PsiElement element2;
        if (editor == null) {
            UnSelectWordHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UnSelectWordHandler.$$$reportNull$$$0(2);
        }
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        int cursorOffset = editor.getCaretModel().getOffset();
        if (cursorOffset > 0 && cursorOffset < text2.length() && !Character.isJavaIdentifierPart(text2.charAt(cursorOffset)) && Character.isJavaIdentifierPart(text2.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if ((element2 = file2.findElementAt(cursorOffset)) instanceof PsiWhiteSpace && cursorOffset > 0 && !((anotherElement = file2.findElementAt(cursorOffset - 1)) instanceof PsiWhiteSpace)) {
            element2 = anotherElement;
        }
        if (element2 instanceof PsiWhiteSpace) {
            PsiElement nextSibling = element2.getNextSibling();
            if (nextSibling == null) {
                if ((element2 = element2.getParent()) == null || element2 instanceof PsiFile) {
                    return;
                }
                nextSibling = element2.getNextSibling();
                if (nextSibling == null) {
                    return;
                }
            }
            element2 = nextSibling;
            cursorOffset = element2.getTextRange().getStartOffset();
        }
        final TextRange selectionRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        final Ref maximumRange = new Ref();
        final int finalCursorOffset = cursorOffset;
        SelectWordUtil.processRanges(element2, text2, cursorOffset, editor, (Processor<? super TextRange>)new Processor<TextRange>(){

            public boolean process(TextRange range2) {
                if (selectionRange.contains(range2 = this.expandToFoldingBoundaries(range2)) && !range2.equals((Object)selectionRange) && (range2.contains(finalCursorOffset) || finalCursorOffset == range2.getEndOffset()) && (maximumRange.get() == null || range2.contains((TextRange)maximumRange.get()))) {
                    maximumRange.set((Object)range2);
                }
                return false;
            }

            private TextRange expandToFoldingBoundaries(TextRange range2) {
                int startOffset = range2.getStartOffset();
                FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
                if (region != null) {
                    startOffset = region.getStartOffset();
                }
                int endOffset = range2.getEndOffset();
                region = editor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
                if (region != null && endOffset > region.getStartOffset()) {
                    endOffset = region.getEndOffset();
                }
                return new TextRange(startOffset, endOffset);
            }
        });
        TextRange range2 = (TextRange)maximumRange.get();
        if (range2 == null) {
            editor.getSelectionModel().setSelection(cursorOffset, cursorOffset);
        } else {
            editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/UnSelectWordHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

