/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class XmlWriterWrapper
implements Closeable {
    private final Project myProject;
    private final Path myOutputDirectory;
    private final String myName;
    private final String myRootTagName;
    private Writer myFileWriter;
    private JbXmlOutputter myOutputter;

    XmlWriterWrapper(@NotNull Project project, @NotNull Path outputDirectory, @NotNull String name, @NotNull String rootTagName) {
        if (project == null) {
            XmlWriterWrapper.$$$reportNull$$$0(0);
        }
        if (outputDirectory == null) {
            XmlWriterWrapper.$$$reportNull$$$0(1);
        }
        if (name == null) {
            XmlWriterWrapper.$$$reportNull$$$0(2);
        }
        if (rootTagName == null) {
            XmlWriterWrapper.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myOutputDirectory = outputDirectory;
        this.myName = name;
        this.myRootTagName = rootTagName;
    }

    void writeElement(@NotNull Element element2) {
        if (element2 == null) {
            XmlWriterWrapper.$$$reportNull$$$0(4);
        }
        try {
            this.checkOpen();
            this.myFileWriter.write(10);
            this.myOutputter.output(element2, this.myFileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void checkOpen() throws IOException {
        if (this.myFileWriter == null) {
            this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectory, this.myName);
            this.myOutputter = JbXmlOutputter.createOutputter((ComponentManager)this.myProject);
            this.startWritingXml();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myFileWriter == null) {
            return;
        }
        try {
            this.endWritingXml();
        }
        finally {
            Writer fileWriter = this.myFileWriter;
            this.myFileWriter = null;
            fileWriter.close();
        }
    }

    @NotNull
    private static Writer openFile(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
        if (outputDirectory == null) {
            XmlWriterWrapper.$$$reportNull$$$0(5);
        }
        if (name == null) {
            XmlWriterWrapper.$$$reportNull$$$0(6);
        }
        BufferedWriter bufferedWriter = InspectionsResultUtil.getWriter(outputDirectory, name);
        if (bufferedWriter == null) {
            XmlWriterWrapper.$$$reportNull$$$0(7);
        }
        return bufferedWriter;
    }

    private void startWritingXml() throws IOException {
        this.myFileWriter.write(60);
        this.myFileWriter.write(this.myRootTagName);
        this.myFileWriter.write(62);
    }

    private void endWritingXml() throws IOException {
        try {
            this.myFileWriter.write("\n");
            this.myFileWriter.write(60);
            this.myFileWriter.write(47);
            this.myFileWriter.write(this.myRootTagName);
            this.myFileWriter.write(62);
        }
        finally {
            this.myFileWriter.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/actions/XmlWriterWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/actions/XmlWriterWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "openFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

