/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.RunConfigurationSchemeManagerKt;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.TemplateDifferenceHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ>\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J(\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0002J&\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/execution/impl/RunConfigurationSchemeManager;", "Lcom/intellij/configurationStore/LazySchemeProcessor;", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "Lcom/intellij/configurationStore/SchemeContentChangedHandler;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "templateDifferenceHelper", "Lcom/intellij/execution/impl/TemplateDifferenceHelper;", "isShared", "", "isWrapSchemeIntoComponentElement", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/impl/TemplateDifferenceHelper;ZZ)V", "createScheme", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "name", "", "attributeProvider", "Ljava/util/function/Function;", "isBundled", "getSchemeKey", "scheme", "fileNameWithoutExtension", "isExternalizable", "onSchemeAdded", "", "onSchemeDeleted", "readData", "Lorg/jdom/Element;", "settings", "schemeContentChanged", "writeScheme", "intellij.platform.execution.impl"})
public final class RunConfigurationSchemeManager
extends LazySchemeProcessor<RunnerAndConfigurationSettingsImpl, RunnerAndConfigurationSettingsImpl>
implements SchemeContentChangedHandler<RunnerAndConfigurationSettingsImpl> {
    private final RunManagerImpl manager;
    private final TemplateDifferenceHelper templateDifferenceHelper;
    private final boolean isShared;
    private final boolean isWrapSchemeIntoComponentElement;

    @Override
    @NotNull
    public String getSchemeKey(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return this.isShared ? (scheme.getType().isManaged() ? scheme.getName() : scheme.getUniqueID()) : scheme.getType().getId() + '-' + scheme.getName();
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettingsImpl createScheme(@NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this.manager, null, false, null, 14, null);
        Element element2 = this.readData(settings, dataHolder);
        this.manager.addConfiguration$intellij_platform_execution_impl(element2, settings, false);
        return settings;
    }

    /*
     * WARNING - void declaration
     */
    private final Element readData(RunnerAndConfigurationSettingsImpl settings, SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        void $this$filterIsInstanceTo$iv$iv;
        Element element2 = dataHolder.read();
        if (this.isShared && Intrinsics.areEqual((Object)element2.getName(), (Object)"component")) {
            Element element3 = element2.getChild("configuration");
            if (element3 == null) {
                throw (Throwable)new RuntimeException("Unexpected element: " + JDOMUtil.write((Element)element2));
            }
            element2 = element3;
        }
        ExtensionPointName extensionPointName = ConfigurationType.CONFIGURATION_TYPE_EP;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ConfigurationType.CONFIGURATION_TYPE_EP");
        List list2 = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ConfigurationType.CONFIG\u2026ION_TYPE_EP.extensionList");
        Iterable $this$filterIsInstance$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RunConfigurationConverter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$any$iv = (List)destination$iv$iv;
        boolean $i$f$any = false;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            for (Object element$iv : $this$any$iv) {
                Object object;
                RunConfigurationConverter it = (RunConfigurationConverter)element$iv;
                boolean bl = false;
                Logger $this$runAndLogException$iv = RunConfigurationSchemeManagerKt.access$getLOG$p();
                boolean $i$f$runAndLogException = false;
                boolean bl2 = false;
                try {
                    object = Result.Companion;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Boolean bl5 = it.convertRunConfigurationOnDemand(element2);
                    boolean bl6 = false;
                    object = Result.constructor-impl((Object)bl5);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl7 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Boolean bl8 = (Boolean)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                if (!(bl8 != null ? bl8 : false)) continue;
                break;
            }
        }
        try {
            settings.readExternal(element2, this.isShared);
        }
        catch (InvalidDataException e) {
            RunConfigurationSchemeManagerKt.access$getLOG$p().error((Throwable)e);
        }
        Element elementAfterStateLoaded = element2;
        if (!settings.needsToBeMigrated()) {
            try {
                elementAfterStateLoaded = this.writeScheme(settings);
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                RunConfigurationSchemeManagerKt.access$getLOG$p().error("Cannot compute digest for RC using state after load", e);
            }
        }
        dataHolder.updateDigest(elementAfterStateLoaded);
        return element2;
    }

    @Override
    @Nullable
    public String getSchemeKey(@NotNull Function<String, String> attributeProvider, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        String name = attributeProvider.apply("name");
        if (Intrinsics.areEqual((Object)name, (Object)"<template>") || name == null) {
            String string = attributeProvider.apply("type");
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (name == null) {
                    name = "<template>";
                }
                name = Intrinsics.stringPlus((String)name, (Object)(" of type " + it));
            }
        } else if (name != null && !this.isShared) {
            String typeId = attributeProvider.apply("type");
            RunConfigurationSchemeManagerKt.access$getLOG$p().assertTrue(typeId != null);
            return typeId + '-' + name;
        }
        return name;
    }

    @Override
    public boolean isExternalizable(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return true;
    }

    @Override
    public void schemeContentChanged(@NotNull RunnerAndConfigurationSettingsImpl scheme, @NotNull String name, @NotNull SchemeDataHolder<? super RunnerAndConfigurationSettingsImpl> dataHolder) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        this.readData(scheme, dataHolder);
        this.manager.getEventPublisher$intellij_platform_execution_impl().runConfigurationChanged(scheme);
    }

    @Override
    public void onSchemeAdded(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
    }

    @Override
    public void onSchemeDeleted(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        RunManagerImpl.removeConfigurations$intellij_platform_execution_impl$default(this.manager, CollectionsKt.listOf((Object)scheme), false, true, 2, null);
    }

    @Override
    @Nullable
    public Element writeScheme(@NotNull RunnerAndConfigurationSettingsImpl scheme) {
        ConfigurationFactory factory2;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Element element2 = super.writeScheme(scheme);
        if (element2 == null) {
            return null;
        }
        Element result2 = element2;
        if (this.isShared && this.isWrapSchemeIntoComponentElement) {
            return new Element("component").setAttribute("name", "ProjectRunConfigurationManager").addContent(result2);
        }
        if (scheme.isTemplate() && Intrinsics.areEqual((Object)(factory2 = scheme.getFactory()), (Object)UnknownConfigurationType.getInstance()) ^ true && !this.templateDifferenceHelper.isTemplateModified(result2, factory2)) {
            return null;
        }
        return result2;
    }

    public RunConfigurationSchemeManager(@NotNull RunManagerImpl manager, @NotNull TemplateDifferenceHelper templateDifferenceHelper, boolean isShared, boolean isWrapSchemeIntoComponentElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)manager), (String)"manager");
        Intrinsics.checkNotNullParameter((Object)templateDifferenceHelper, (String)"templateDifferenceHelper");
        super(null, 1, null);
        this.manager = manager;
        this.templateDifferenceHelper = templateDifferenceHelper;
        this.isShared = isShared;
        this.isWrapSchemeIntoComponentElement = isWrapSchemeIntoComponentElement;
    }
}

