/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class InvalidateCachesAction
extends AnAction
implements DumbAware {
    public InvalidateCachesAction() {
        String text2 = ApplicationManager.getApplication().isRestartCapable() ? ActionsBundle.message((String)"action.InvalidateCachesRestart.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.InvalidateCaches.text", (Object[])new Object[0]);
        this.getTemplatePresentation().setText(text2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ApplicationEx app;
        boolean canRestart;
        if (e == null) {
            InvalidateCachesAction.$$$reportNull$$$0(0);
        }
        String[] options2 = new String[(canRestart = (app = (ApplicationEx)ApplicationManager.getApplication()).isRestartCapable()) ? 3 : 2];
        options2[0] = canRestart ? IdeBundle.message((String)"button.invalidate.and.restart", (Object[])new Object[0]) : IdeBundle.message((String)"button.invalidate.and.exit", (Object[])new Object[0]);
        options2[1] = IdeBundle.message((String)"button.cancel.without.mnemonic", (Object[])new Object[0]);
        if (canRestart) {
            options2[2] = IdeBundle.message((String)"button.just.restart", (Object[])new Object[0]);
        }
        SmartList descriptions = new SmartList();
        boolean invalidateCachesInvalidatesVfs = Registry.is((String)"idea.invalidate.caches.invalidates.vfs");
        if (invalidateCachesInvalidatesVfs) {
            descriptions.add("Local History");
        }
        for (CachesInvalidator invalidator : (CachesInvalidator[])CachesInvalidator.EP_NAME.getExtensions()) {
            ContainerUtil.addIfNotNull((Collection)descriptions, (Object)invalidator.getDescription());
        }
        Collections.sort(descriptions);
        Object warnings = IdeBundle.message((String)"dialog.message.warning", (Object[])new Object[0]);
        if (descriptions.size() == 1) {
            warnings = (String)warnings + " " + IdeBundle.message((String)"dialog.message.will.be.also.cleared", (Object[])new Object[]{descriptions.get(0)});
        } else if (!descriptions.isEmpty()) {
            warnings = (String)warnings + " " + IdeBundle.message((String)"dialog.message.the.following.items", (Object[])new Object[0]) + "\n" + StringUtil.join((Collection)descriptions, s -> "  " + s, (String)"\n");
        }
        String message = IdeBundle.message((String)"dialog.message.caches.will.be.invalidated", (Object[])new Object[]{descriptions.isEmpty() ? "" : "\n\n" + (String)warnings});
        int result2 = Messages.showDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)message, (String)IdeBundle.message((String)"dialog.title.invalidate.caches", (Object[])new Object[0]), (String[])options2, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 == -1 || result2 == 1) {
            return;
        }
        if (result2 == 2) {
            app.restart(true);
            return;
        }
        if (invalidateCachesInvalidatesVfs) {
            FSRecords.invalidateCaches();
        } else {
            FileBasedIndex.getInstance().invalidateCaches();
            GistManager.getInstance().invalidateData();
        }
        for (CachesInvalidator invalidater : (CachesInvalidator[])CachesInvalidator.EP_NAME.getExtensions()) {
            invalidater.invalidateCaches();
        }
        if (result2 == 0) {
            app.restart(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/InvalidateCachesAction", "actionPerformed"));
    }
}

