/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardParagraphAction
extends EditorAction {
    public ForwardParagraphAction() {
        super((EditorActionHandler)new Handler(false));
    }

    static class Handler
    extends EditorActionHandler {
        private final boolean myWithSelection;

        Handler(boolean withSelection) {
            super(true);
            this.myWithSelection = withSelection;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            Document document = editor.getDocument();
            int currentLine = caret.getLogicalPosition().line;
            int lineCount = document.getLineCount();
            if (DocumentUtil.isLineEmpty(document, currentLine)) {
                while (++currentLine < lineCount && DocumentUtil.isLineEmpty(document, currentLine)) {
                }
            }
            int targetOffset = document.getTextLength();
            while (++currentLine < lineCount) {
                if (!DocumentUtil.isLineEmpty(document, currentLine)) continue;
                targetOffset = document.getLineStartOffset(currentLine);
                break;
            }
            EditorActionUtil.moveCaret(caret, targetOffset, this.myWithSelection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/ForwardParagraphAction$Handler", "doExecute"));
        }
    }
}

