/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComplementaryFontsRegistry {
    private static final Logger LOG = Logger.getInstance(ComplementaryFontsRegistry.class);
    private static final String DEFAULT_FALLBACK_FONT = "Monospaced";
    private static final Object lock = new Object();
    private static final List<String>[] ourFontNames = new List[4];
    private static final Map<String, Pair<String, Integer>[]> ourStyledFontMap = new HashMap<String, Pair<String, Integer>[]>();
    private static final LinkedHashMap<String, FallBackInfo>[] ourUsedFonts = new LinkedHashMap[]{new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap(), new LinkedHashMap()};
    private static final FallBackInfo UNDISPLAYABLE_FONT_INFO = new FallBackInfo("JetBrains Mono", 0, 0);
    private static final TIntHashSet[] ourUndisplayableChars = new TIntHashSet[]{new TIntHashSet(), new TIntHashSet(), new TIntHashSet(), new TIntHashSet()};
    private static String ourLastFontFamily = null;
    private static int ourLastFontStyle = -1;
    private static FallBackInfo ourLastFallBackInfo = null;
    @NonNls
    private static final String[] BOLD_NAMES = new String[]{"bold", "demibold", "demi-bold", "demi bold", "negreta", "demi"};
    @NonNls
    private static final String[] ITALIC_NAMES = new String[]{"italic", "cursiva", "oblique", "inclined"};
    @NonNls
    private static final String[] BOLD_ITALIC_NAMES = new String[]{"bolditalic", "bold-italic", "bold italic", "boldoblique", "bold-oblique", "bold oblique", "demibold italic", "negreta cursiva", "demi oblique"};
    @NonNls
    private static final Map<String, Integer> FONT_NAME_TO_STYLE = new HashMap<String, Integer>();
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";
    private static final String ADOBE_BLANK = "Adobe Blank";

    private ComplementaryFontsRegistry() {
    }

    private static void fillStyledFontMap() {
        Font[] allFonts;
        for (Font font : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String name = font.getName();
            Integer style = FONT_NAME_TO_STYLE.get(name);
            if (style == null || style == 0) continue;
            String familyName = font.getFamily();
            Pair<String, Integer>[] entry = ourStyledFontMap.get(familyName);
            if (entry == null) {
                entry = new Pair[4];
                for (int i2 = 1; i2 < 4; ++i2) {
                    entry[i2] = Pair.create((Object)familyName, (Object)i2);
                }
                ourStyledFontMap.put(familyName, entry);
            }
            entry[style.intValue()] = Pair.create((Object)name, (Object)0);
        }
    }

    @JdkConstants.FontStyle
    static int getFontStyle(String fontName) {
        fontName = fontName.toLowerCase(Locale.getDefault());
        for (String name : BOLD_ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 3;
        }
        for (String name : ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 2;
        }
        for (String name : BOLD_NAMES) {
            if (!fontName.contains(name)) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(@NotNull CharSequence text2, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        if (text2 == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(0);
        }
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(1);
        }
        assert (0 <= start2 && start2 < end && end <= text2.length()) : "Start: " + start2 + ", end: " + end + ", length: " + text2.length();
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text2.charAt(start2), style, preferences, context);
        }
        int firstCodePoint = Character.codePointAt(text2, start2);
        int secondOffset = Character.offsetByCodePoints(text2, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
        }
        char[] tmp = CharArrayUtil.fromSequence((CharSequence)text2, (int)secondOffset, (int)end);
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, tmp, 0, tmp.length, style, preferences, context);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(2);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(char @NotNull [] text2, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(4);
        }
        assert (0 <= start2 && start2 < end && end <= text2.length) : "Start: " + start2 + ", end: " + end + ", length: " + text2.length;
        if (end - start2 == 1) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(text2[start2], style, preferences, context);
        }
        int firstCodePoint = Character.codePointAt(text2, start2);
        int secondOffset = Character.offsetByCodePoints(text2, start2, end - start2, start2, 1);
        if (secondOffset == end) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, style, preferences, context);
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(firstCodePoint, text2, secondOffset, end, style, preferences, context);
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(5);
        }
        return fontInfo;
    }

    private static FontInfo getFontAbleToDisplay(int codePoint, char @NotNull [] remainingText, int start2, int end, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(6);
        }
        if (remainingText == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(7);
        }
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = !Patches.TEXT_LAYOUT_IS_SLOW && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context, len > 1);
            if (result2 != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
                return result2;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, useLigatures, context, false)) != null && result2.getFont().canDisplayUpTo(remainingText, start2, end) == -1) {
            return result2;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, remainingText, start2, end, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        return result2;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences, FontRenderContext context) {
        FontInfo result2;
        if (preferences == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(8);
        }
        boolean tryDefaultFallback = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = !Patches.TEXT_LAYOUT_IS_SLOW && preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i2 = 0; i2 < len; ++i2) {
            String fontFamily = (String)fontFamilies.get(i2);
            result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures, context, len > 1);
            if (result2 != null) {
                FontInfo fontInfo = result2;
                if (fontInfo == null) {
                    ComplementaryFontsRegistry.$$$reportNull$$$0(9);
                }
                return fontInfo;
            }
            tryDefaultFallback &= !DEFAULT_FALLBACK_FONT.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFallback && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, useLigatures, context, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(10);
            }
            return fontInfo;
        }
        result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, useLigatures, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result2.getFont().getFontName());
        }
        FontInfo fontInfo = result2;
        if (fontInfo == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(11);
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily, FontRenderContext context) {
        FontInfo result2;
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(12);
        }
        if ((result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, defaultFontFamily, false, context, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(13);
            }
            return fontInfo;
        }
        if (!DEFAULT_FALLBACK_FONT.equals(defaultFontFamily) && (result2 = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, DEFAULT_FALLBACK_FONT, false, context, false)) != null) {
            FontInfo fontInfo = result2;
            if (fontInfo == null) {
                ComplementaryFontsRegistry.$$$reportNull$$$0(14);
            }
            return fontInfo;
        }
        return ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, null, 0, 0, size, style, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int originalStyle, @NotNull String defaultFontFamily, boolean useLigatures, FontRenderContext context, boolean disableFontFallback) {
        if (defaultFontFamily == null) {
            ComplementaryFontsRegistry.$$$reportNull$$$0(15);
        }
        if (originalStyle < 0 || originalStyle > 3) {
            originalStyle = 0;
        }
        Object object = lock;
        synchronized (object) {
            FallBackInfo fallBackInfo;
            Pair<String, Integer>[] replacement;
            int style = originalStyle;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND && style != 0 && (replacement = ourStyledFontMap.get(defaultFontFamily)) != null) {
                defaultFontFamily = (String)replacement[style].first;
                style = (Integer)replacement[style].second;
            }
            if (ourLastFontStyle == style && ourLastFontFamily.equals(defaultFontFamily) && ourLastFallBackInfo.canDisplay(codePoint, disableFontFallback)) {
                fallBackInfo = ourLastFallBackInfo;
            } else {
                LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
                fallBackInfo = usedFonts.get(defaultFontFamily);
                if (fallBackInfo == null) {
                    fallBackInfo = new FallBackInfo(defaultFontFamily, style, originalStyle);
                    usedFonts.put(defaultFontFamily, fallBackInfo);
                }
                ourLastFontFamily = defaultFontFamily;
                ourLastFontStyle = style;
                ourLastFallBackInfo = fallBackInfo;
            }
            return fallBackInfo.canDisplay(codePoint, disableFontFallback) ? fallBackInfo.getFontInfo(size, useLigatures, context) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, char[] remainingText, int start2, int end, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext context) {
        if (style < 0 || style > 3) {
            style = 0;
        }
        Object object = lock;
        // MONITORENTER : object
        FallBackInfo fallBackInfo = UNDISPLAYABLE_FONT_INFO;
        TIntHashSet undisplayableChars = ourUndisplayableChars[style];
        if (!undisplayableChars.contains(codePoint)) {
            boolean canDisplayFirst = false;
            LinkedHashMap<String, FallBackInfo> usedFonts = ourUsedFonts[style];
            Collection<FallBackInfo> descriptors2 = usedFonts.values();
            for (FallBackInfo info : descriptors2) {
                if (info.myOriginalStyle != style || !info.canDisplay(codePoint, false)) continue;
                canDisplayFirst = true;
                if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                fallBackInfo = info;
                break;
            }
            if (fallBackInfo == UNDISPLAYABLE_FONT_INFO) {
                List<String> fontNames = ourFontNames[style];
                for (int i2 = 0; i2 < fontNames.size(); ++i2) {
                    String name = fontNames.get(i2);
                    FallBackInfo info = new FallBackInfo(name, style, style);
                    if (!info.canDisplay(codePoint, false)) continue;
                    canDisplayFirst = true;
                    if (remainingText != null && info.myBaseFont.canDisplayUpTo(remainingText, start2, end) != -1) continue;
                    usedFonts.put(name, info);
                    fontNames.remove(i2);
                    fallBackInfo = info;
                    break;
                }
                if (fallBackInfo == UNDISPLAYABLE_FONT_INFO && !canDisplayFirst) {
                    undisplayableChars.add(codePoint);
                }
            }
        }
        FontInfo fontInfo = fallBackInfo.getFontInfo(size, useLigatures, context);
        // MONITOREXIT : object
        if (fontInfo != null) return fontInfo;
        ComplementaryFontsRegistry.$$$reportNull$$$0(16);
        return fontInfo;
    }

    static {
        FONT_NAME_TO_STYLE.put("AnkaCoder-b", 1);
        FONT_NAME_TO_STYLE.put("AnkaCoder-i", 2);
        FONT_NAME_TO_STYLE.put("AnkaCoder-bi", 3);
        FONT_NAME_TO_STYLE.put("SourceCodePro-It", 2);
        FONT_NAME_TO_STYLE.put("SourceCodePro-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("Hasklig-It", 2);
        FONT_NAME_TO_STYLE.put("Hasklig-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("FiraCode-Medium", 1);
        ArrayList<String> fontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            fontNames.add(DEFAULT_FALLBACK_FONT);
        } else {
            String[] families;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND) {
                ComplementaryFontsRegistry.fillStyledFontMap();
            }
            for (String fontName : families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX) || fontName.equals(ADOBE_BLANK)) continue;
                fontNames.add(fontName);
            }
        }
        ComplementaryFontsRegistry.ourFontNames[0] = fontNames;
        for (int i2 = 1; i2 < 4; ++i2) {
            ComplementaryFontsRegistry.ourFontNames[i2] = new ArrayList<String>(fontNames);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingText";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFontFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontAbleToDisplay";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFontAbleToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFontAbleToDisplay";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetFontAbleToDisplay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FallBackInfo {
        private final Font myBaseFont;
        private final int myOriginalStyle;
        private final Map<FontKey, FontInfo> myFontInfoMap = new HashMap<FontKey, FontInfo>();
        private final FontKey myLastFontKey = new FontKey(-1, false, new FontRenderContext(null, false, false));
        private FontInfo myLastFontInfo;

        private FallBackInfo(String familyName, @JdkConstants.FontStyle int style, int originalStyle) {
            this.myBaseFont = new Font(familyName, style, 1);
            this.myOriginalStyle = originalStyle;
        }

        private boolean canDisplay(int codePoint, boolean disableFontFallback) {
            return codePoint < 128 || FontInfo.canDisplay(this.myBaseFont, codePoint, disableFontFallback);
        }

        private FontInfo getFontInfo(int size, boolean useLigatures, FontRenderContext fontRenderContext) {
            if (this.myLastFontKey.mySize == size && this.myLastFontKey.myUseLigatures == useLigatures && Objects.equals(this.myLastFontKey.myContext, fontRenderContext)) {
                return this.myLastFontInfo;
            }
            this.myLastFontKey.mySize = size;
            this.myLastFontKey.myUseLigatures = useLigatures;
            this.myLastFontKey.myContext = fontRenderContext;
            FontInfo fontInfo = this.myFontInfoMap.get(this.myLastFontKey);
            if (fontInfo == null) {
                fontInfo = new FontInfo(this.myBaseFont.getName(), size, this.myBaseFont.getStyle(), useLigatures, fontRenderContext);
                this.myFontInfoMap.put(this.myLastFontKey.clone(), fontInfo);
            }
            this.myLastFontInfo = fontInfo;
            return fontInfo;
        }
    }

    private static final class FontKey
    implements Cloneable {
        private int mySize;
        private boolean myUseLigatures;
        private FontRenderContext myContext;

        private FontKey(int size, boolean useLigatures, FontRenderContext context) {
            this.mySize = size;
            this.myUseLigatures = useLigatures;
            this.myContext = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontKey key = (FontKey)o;
            if (this.mySize != key.mySize) {
                return false;
            }
            if (this.myUseLigatures != key.myUseLigatures) {
                return false;
            }
            return Objects.equals(this.myContext, key.myContext);
        }

        public int hashCode() {
            int result2 = this.mySize;
            result2 = 31 * result2 + (this.myUseLigatures ? 1 : 0);
            result2 = 31 * result2 + (this.myContext != null ? this.myContext.hashCode() : 0);
            return result2;
        }

        protected FontKey clone() {
            try {
                return (FontKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

