/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.keyGestures;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.keymap.impl.keyGestures.GestureActionEvent;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.keyGestures.StateContext;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

abstract class KeyGestureState {
    final KeyboardGestureProcessor myProcessor;
    final StateContext myContext;

    KeyGestureState(KeyboardGestureProcessor processor2) {
        this.myProcessor = processor2;
        this.myContext = processor2.myContext;
    }

    abstract boolean process();

    public void processDblClickTimer() {
        this.myProcessor.setState(this.myProcessor.myWaitForStart);
        this.myProcessor.myDblClickTimer.stop();
    }

    public String toString() {
        return this.getClass().getName();
    }

    boolean isPureModifierEvent(int eventType) {
        KeyEvent event = this.myContext.keyToProcess;
        if (event.getID() != eventType) {
            return false;
        }
        return event.getKeyCode() == 17 || event.getKeyCode() == 18 || event.getKeyCode() == 16 || event.getKeyCode() == 157;
    }

    @NotNull
    public AnActionEvent createActionEvent() {
        throw new IllegalStateException(this.getClass().getName());
    }

    static class WaitForActionEnd
    extends KeyGestureState {
        WaitForActionEnd(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            if (this.myContext.keyToProcess.getID() == 402) {
                this.myProcessor.executeAction();
                this.myProcessor.setState(this.myProcessor.myWaitForAction);
                return true;
            }
            return false;
        }

        @Override
        public AnActionEvent createActionEvent() {
            return new GestureActionEvent.PerformAction(this.myProcessor);
        }
    }

    static class ProcessFinish
    extends KeyGestureState {
        ProcessFinish(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            this.myProcessor.executeAction();
            this.myProcessor.setState(this.myProcessor.myWaitForStart);
            return false;
        }

        @Override
        public AnActionEvent createActionEvent() {
            return new GestureActionEvent.Finish(this.myProcessor);
        }
    }

    static class WaitForAction
    extends KeyGestureState {
        WaitForAction(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            int pressedModifiers;
            if (this.isPureModifierEvent(401)) {
                this.myContext.actionKey = this.myContext.keyToProcess;
                return true;
            }
            if (this.myContext.keyToProcess.getID() == 402 && this.myContext.keyToProcess.getKeyChar() == '\uffff' && (pressedModifiers = this.myContext.keyToProcess.getKeyCode() & this.myContext.actionKey.getModifiersEx()) == 0) {
                this.myProcessor.setState(this.myProcessor.myFinish);
                return this.myProcessor.myState.process();
            }
            if (this.myContext.keyToProcess.getID() == 401) {
                this.myContext.actionKey = this.myContext.keyToProcess;
                this.myProcessor.setState(this.myProcessor.myWaitForActionEnd);
                return true;
            }
            return false;
        }

        @Override
        public AnActionEvent createActionEvent() {
            return new GestureActionEvent.Init(this.myProcessor);
        }
    }

    static class WaitForDblClick
    extends KeyGestureState {
        WaitForDblClick(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            this.myProcessor.myDblClickTimer.stop();
            if (this.isPureModifierEvent(402)) {
                return false;
            }
            if (!this.isPureModifierEvent(401)) {
                this.myProcessor.setState(this.myProcessor.myWaitForStart);
                return false;
            }
            this.myContext.actionKey = this.myContext.keyToProcess;
            this.myProcessor.setState(this.myProcessor.myWaitForAction);
            this.myContext.actionShortcut = KeyStroke.getKeyStrokeForEvent(this.myContext.actionKey);
            this.myContext.modifierType = KeyboardGestureAction.ModifierType.dblClick;
            this.myProcessor.executeAction();
            return true;
        }
    }

    static class ModifierPressed
    extends KeyGestureState {
        ModifierPressed(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            if (this.isPureModifierEvent(402)) {
                this.myProcessor.myHoldTimer.stop();
                this.myContext.actionKey = null;
                this.myProcessor.setState(this.myProcessor.myWaitForDblClick);
                this.myProcessor.myDblClickTimer.start();
                this.myContext.actionKey = this.myContext.keyToProcess;
                return false;
            }
            if (this.isPureModifierEvent(401)) {
                this.myContext.actionKey = this.myContext.keyToProcess;
                return false;
            }
            this.myProcessor.setState(this.myProcessor.myWaitForStart);
            return false;
        }
    }

    static class WaitForStart
    extends KeyGestureState {
        WaitForStart(KeyboardGestureProcessor processor2) {
            super(processor2);
        }

        @Override
        boolean process() {
            if (!this.isPureModifierEvent(401)) {
                return false;
            }
            this.myProcessor.myContext.actionKey = this.myProcessor.myContext.keyToProcess;
            this.myProcessor.setState(this.myProcessor.myModifierPressed);
            this.myProcessor.myHoldTimer.start();
            return false;
        }
    }
}

