/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleRootManagerImpl
extends ModuleRootManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(ModuleRootManagerImpl.class);
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    protected RootModelImpl myRootModel;
    private boolean myIsDisposed;
    private boolean myLoaded;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations;
    protected final SimpleModificationTracker myModificationTracker;

    public ModuleRootManagerImpl(@NotNull Module module) {
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModelCreations = new HashMap<RootModelImpl, Throwable>();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myModule = module;
        this.myProjectRootManager = ProjectRootManagerImpl.getInstanceImpl(module.getProject());
        this.myFilePointerManager = VirtualFilePointerManager.getInstance();
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
        this.myOrderRootsCache = new OrderRootsCache((Disposable)module);
        MODULE_EXTENSION_NAME.getPoint((AreaInstance)module).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ModuleExtension>(){

            public void extensionAdded(@NotNull ModuleExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ModuleRootManagerImpl.this.myRootModel.addModuleExtension(extension);
            }

            public void extensionRemoved(@NotNull ModuleExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ModuleRootManagerImpl.this.myRootModel.removeModuleExtension(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleRootManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, null);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(1);
        }
        return module;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        ModuleFileIndex moduleFileIndex = (ModuleFileIndex)this.myModule.getService(ModuleFileIndex.class);
        if (moduleFileIndex == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(2);
        }
        return moduleFileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            ArrayList<Map.Entry<RootModelImpl, Throwable>> entries;
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                entries = new ArrayList<Map.Entry<RootModelImpl, Throwable>>(this.myModelCreations.entrySet());
            }
            for (Map.Entry entry : entries) {
                LOG.warn("\n***********************************************************************************************\n***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***\n***********************************************************************************************\nCreated at:", (Throwable)entry.getValue());
                ((RootModelImpl)entry.getKey()).dispose();
            }
        }
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        ModifiableRootModel modifiableRootModel = this.getModifiableModel(RootConfigurationAccessor.DEFAULT_INSTANCE);
        if (modifiableRootModel == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(3);
        }
        return modifiableRootModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModifiableRootModel getModifiableModel(@NotNull RootConfigurationAccessor accessor) {
        if (accessor == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model2 = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                super.dispose();
                if (Disposer.isDebugMode()) {
                    Map<RootModelImpl, Throwable> map2 = ModuleRootManagerImpl.this.myModelCreations;
                    synchronized (map2) {
                        ModuleRootManagerImpl.this.myModelCreations.remove(this);
                    }
                }
            }
        };
        if (Disposer.isDebugMode()) {
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                this.myModelCreations.put(model2, new Throwable());
            }
        }
        RootModelImpl rootModelImpl = model2;
        if (rootModelImpl == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(5);
        }
        return rootModelImpl;
    }

    @Override
    @TestOnly
    public long getModificationCountForTests() {
        throw new NotImplementedError("Make sense only for persistent root manager");
    }

    void makeRootsChange(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(6);
        }
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable2, false, this.myModule.isLoaded());
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    public ContentEntry @NotNull [] getContentEntries() {
        ContentEntry[] contentEntryArray = this.myRootModel.getContentEntries();
        if (contentEntryArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(7);
        }
        return contentEntryArray;
    }

    public OrderEntry @NotNull [] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(8);
        }
        return orderEntryArray;
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        LOG.assertTrue(!this.myIsDisposed);
        boolean changed2 = rootModel.isChanged();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)this.myModule.getProject()).getModifiableModel();
        ModifiableModelCommitter.multiCommit(Collections.singletonList(rootModel), moduleModel);
        if (changed2) {
            this.stateChanged();
        }
    }

    static void doCommit(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(10);
        }
        ModuleRootManagerImpl rootManager = (ModuleRootManagerImpl)ModuleRootManagerImpl.getInstance((Module)rootModel.getModule());
        LOG.assertTrue(!rootManager.myIsDisposed);
        rootModel.doCommit();
        rootModel.dispose();
        try {
            rootManager.stateChanged();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public Module @NotNull [] getDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(11);
        }
        return moduleArray;
    }

    public Module @NotNull [] getDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(12);
        }
        return moduleArray;
    }

    public Module @NotNull [] getModuleDependencies() {
        Module[] moduleArray = this.myRootModel.getModuleDependencies();
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(13);
        }
        return moduleArray;
    }

    public Module @NotNull [] getModuleDependencies(boolean includeTests) {
        Module[] moduleArray = this.myRootModel.getModuleDependencies(includeTests);
        if (moduleArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(14);
        }
        return moduleArray;
    }

    public boolean isDependsOn(@NotNull Module module) {
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(15);
        }
        return this.myRootModel.findModuleOrderEntry(module) != null;
    }

    public String @NotNull [] getDependencyModuleNames() {
        String[] stringArray = this.myRootModel.getDependencyModuleNames();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        if (klass == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(17);
        }
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(18);
        }
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        if (type == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(19);
        }
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(20);
        }
        return ModuleRootManagerImpl.getEnumeratorForType(type, module).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        if (type == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(21);
        }
        if (module == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(22);
        }
        OrderEnumerator base = OrderEnumerator.orderEntries((Module)module);
        if (type == OrderRootType.CLASSES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
            if (orderRootsEnumerator == null) {
                ModuleRootManagerImpl.$$$reportNull$$$0(23);
            }
            return orderRootsEnumerator;
        }
        if (type == OrderRootType.SOURCES) {
            OrderRootsEnumerator orderRootsEnumerator = base.exportedOnly().recursively().sources();
            if (orderRootsEnumerator == null) {
                ModuleRootManagerImpl.$$$reportNull$$$0(24);
            }
            return orderRootsEnumerator;
        }
        OrderRootsEnumerator orderRootsEnumerator = base.roots(type);
        if (orderRootsEnumerator == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(25);
        }
        return orderRootsEnumerator;
    }

    public VirtualFile @NotNull [] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getContentRoots();
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(26);
        }
        return virtualFileArray;
    }

    public String @NotNull [] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getContentRootUrls();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    public String @NotNull [] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getExcludeRootUrls();
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(28);
        }
        return stringArray;
    }

    public VirtualFile @NotNull [] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getExcludeRoots();
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(29);
        }
        return virtualFileArray;
    }

    public String @NotNull [] getSourceRootUrls() {
        String[] stringArray = this.getSourceRootUrls(true);
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(30);
        }
        return stringArray;
    }

    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        String[] stringArray = this.myRootModel.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(31);
        }
        return stringArray;
    }

    public VirtualFile @NotNull [] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.getSourceRoots(true);
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(32);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        VirtualFile[] virtualFileArray = this.myRootModel.getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(33);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(34);
        }
        List<VirtualFile> list2 = this.myRootModel.getSourceRoots(rootType);
        if (list2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(36);
        }
        List<VirtualFile> list2 = this.myRootModel.getSourceRoots(rootTypes);
        if (list2 == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @Override
    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("getState, module " + this.myModule.getName());
        }
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(@NotNull ModuleRootManagerState object) {
        if (object == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(38);
        }
        this.loadState(object, this.myLoaded || this.myModule.isLoaded());
        this.myLoaded = true;
    }

    protected void loadState(@NotNull ModuleRootManagerState object, boolean throwEvent) {
        if (object == null) {
            ModuleRootManagerImpl.$$$reportNull$$$0(39);
        }
        ThrowableRunnable r = () -> {
            RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(() -> ModuleRootManagerImpl.doCommit(newModel));
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        };
        try {
            if (throwEvent) {
                WriteAction.run((ThrowableRunnable)r);
            } else {
                ReadAction.run((ThrowableRunnable)r);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void stateChanged() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("ModelRootManager state changed");
        }
        this.myModificationTracker.incModificationCount();
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.myModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleRootManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleRootManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentEntries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyModuleNames";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratorForType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootUrls";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRoots";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "makeRootsChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "commitModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDependsOn";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processOrder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachingEnumeratorForType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEnumeratorForType";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element2) {
            this.myRootModelElement = element2;
        }

        public void writeExternal(Element element2) {
            this.myRootModel.writeExternal(element2);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

