/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedFileType {
    private static final ConcurrentMap<FileType, CachedFileType> ourInterner = new ConcurrentHashMap<FileType, CachedFileType>();
    @Nullable
    private FileType fileType;

    private CachedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(0);
        }
        this.fileType = fileType;
    }

    @Nullable
    FileType getUpToDateOrNull() {
        return this.fileType;
    }

    static CachedFileType forType(@NotNull FileType fileType) {
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ourInterner.computeIfAbsent(fileType, CachedFileType::new);
    }

    public static void clearCache() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ourInterner.forEach((type, cachedType) -> {
            cachedType.fileType = null;
        });
        ourInterner.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "fileType";
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/CachedFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ReparseListener
    implements BulkFileListener {
        ReparseListener() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                ReparseListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!"FileContentUtilCore.saveOrReload".equals(vFileEvent.getRequestor())) continue;
                CachedFileType.clearCache();
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/impl/CachedFileType$ReparseListener", "after"));
        }
    }

    static final class PsiListener
    implements PsiModificationTracker.Listener {
        PsiListener() {
        }

        public void modificationCountChanged() {
            CachedFileType.clearCache();
        }
    }
}

