/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

final class PlatformProjectConfigurator
implements DirectoryProjectConfigurator {
    private static final Logger LOG = Logger.getInstance(PlatformProjectConfigurator.class);

    PlatformProjectConfigurator() {
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        ModuleManager moduleManager;
        Module[] modules2;
        if (project == null) {
            PlatformProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PlatformProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PlatformProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((modules2 = (moduleManager = ModuleManager.getInstance((Project)project)).getModules()).length != 0) {
            LOG.info("PlatformProjectConfigurator is not applicable because modules are already configured (module count: " + modules2.length + ")");
            return;
        }
        String moduleName = baseDir.getName().replace(":", "");
        String imlName = baseDir.getPath() + "/.idea/" + moduleName + ".iml";
        ModuleTypeManager moduleTypeManager = ModuleTypeManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module module = moduleManager.newModule(imlName, moduleTypeManager == null ? "unknown" : moduleTypeManager.getDefaultModuleType().getId());
            ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                VirtualFile[] contentRoots = model2.getContentRoots();
                if (contentRoots.length == 0) {
                    model2.addContentEntry(baseDir);
                    LOG.debug("content root " + baseDir + " is added");
                } else {
                    LOG.info("content root " + baseDir + " is not added because content roots are already configured (content root count: " + contentRoots.length + ")");
                }
                model2.inheritSdk();
                model2.commit();
            }
            finally {
                if (!model2.isDisposed()) {
                    model2.dispose();
                }
            }
            moduleRef.set((Object)module);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleRef";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/PlatformProjectConfigurator";
        objectArray[2] = "configureProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

